package alb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateAScripts invokes the alb.UpdateAScripts API synchronously
func (client *Client) UpdateAScripts(request *UpdateAScriptsRequest) (response *UpdateAScriptsResponse, err error) {
	response = CreateUpdateAScriptsResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateAScriptsWithChan invokes the alb.UpdateAScripts API asynchronously
func (client *Client) UpdateAScriptsWithChan(request *UpdateAScriptsRequest) (<-chan *UpdateAScriptsResponse, <-chan error) {
	responseChan := make(chan *UpdateAScriptsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateAScripts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateAScriptsWithCallback invokes the alb.UpdateAScripts API asynchronously
func (client *Client) UpdateAScriptsWithCallback(request *UpdateAScriptsRequest, callback func(response *UpdateAScriptsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateAScriptsResponse
		var err error
		defer close(result)
		response, err = client.UpdateAScripts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateAScriptsRequest is the request struct for api UpdateAScripts
type UpdateAScriptsRequest struct {
	*requests.RpcRequest
	ClientToken string                    `position:"Query" name:"ClientToken"`
	AScripts    *[]UpdateAScriptsAScripts `position:"Query" name:"AScripts"  type:"Repeated"`
	DryRun      requests.Boolean          `position:"Query" name:"DryRun"`
}

// UpdateAScriptsAScripts is a repeated param struct in UpdateAScriptsRequest
type UpdateAScriptsAScripts struct {
	AScriptName         string                                     `name:"AScriptName"`
	AScriptId           string                                     `name:"AScriptId"`
	ExtAttributeEnabled string                                     `name:"ExtAttributeEnabled"`
	ScriptContent       string                                     `name:"ScriptContent"`
	ExtAttributes       *[]UpdateAScriptsAScriptsExtAttributesItem `name:"ExtAttributes" type:"Repeated"`
	Enabled             string                                     `name:"Enabled"`
}

// UpdateAScriptsAScriptsExtAttributesItem is a repeated param struct in UpdateAScriptsRequest
type UpdateAScriptsAScriptsExtAttributesItem struct {
	AttributeValue string `name:"AttributeValue"`
	AttributeKey   string `name:"AttributeKey"`
}

// UpdateAScriptsResponse is the response struct for api UpdateAScripts
type UpdateAScriptsResponse struct {
	*responses.BaseResponse
	JobId     string `json:"JobId" xml:"JobId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateAScriptsRequest creates a request to invoke UpdateAScripts API
func CreateUpdateAScriptsRequest() (request *UpdateAScriptsRequest) {
	request = &UpdateAScriptsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alb", "2020-06-16", "UpdateAScripts", "alb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateAScriptsResponse creates a response to parse from UpdateAScripts response
func CreateUpdateAScriptsResponse() (response *UpdateAScriptsResponse) {
	response = &UpdateAScriptsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
