package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDnsGtmInstanceStatus invokes the alidns.DescribeDnsGtmInstanceStatus API synchronously
func (client *Client) DescribeDnsGtmInstanceStatus(request *DescribeDnsGtmInstanceStatusRequest) (response *DescribeDnsGtmInstanceStatusResponse, err error) {
	response = CreateDescribeDnsGtmInstanceStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDnsGtmInstanceStatusWithChan invokes the alidns.DescribeDnsGtmInstanceStatus API asynchronously
func (client *Client) DescribeDnsGtmInstanceStatusWithChan(request *DescribeDnsGtmInstanceStatusRequest) (<-chan *DescribeDnsGtmInstanceStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeDnsGtmInstanceStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDnsGtmInstanceStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDnsGtmInstanceStatusWithCallback invokes the alidns.DescribeDnsGtmInstanceStatus API asynchronously
func (client *Client) DescribeDnsGtmInstanceStatusWithCallback(request *DescribeDnsGtmInstanceStatusRequest, callback func(response *DescribeDnsGtmInstanceStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDnsGtmInstanceStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeDnsGtmInstanceStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDnsGtmInstanceStatusRequest is the request struct for api DescribeDnsGtmInstanceStatus
type DescribeDnsGtmInstanceStatusRequest struct {
	*requests.RpcRequest
	InstanceId   string `position:"Query" name:"InstanceId"`
	UserClientIp string `position:"Query" name:"UserClientIp"`
	Lang         string `position:"Query" name:"Lang"`
}

// DescribeDnsGtmInstanceStatusResponse is the response struct for api DescribeDnsGtmInstanceStatus
type DescribeDnsGtmInstanceStatusResponse struct {
	*responses.BaseResponse
	StrategyNotAvailableNum      int    `json:"StrategyNotAvailableNum" xml:"StrategyNotAvailableNum"`
	AddrAvailableNum             int    `json:"AddrAvailableNum" xml:"AddrAvailableNum"`
	RequestId                    string `json:"RequestId" xml:"RequestId"`
	SwitchToFailoverStrategyNum  int    `json:"SwitchToFailoverStrategyNum" xml:"SwitchToFailoverStrategyNum"`
	AddrNotAvailableNum          int    `json:"AddrNotAvailableNum" xml:"AddrNotAvailableNum"`
	AddrPoolGroupNotAvailableNum int    `json:"AddrPoolGroupNotAvailableNum" xml:"AddrPoolGroupNotAvailableNum"`
}

// CreateDescribeDnsGtmInstanceStatusRequest creates a request to invoke DescribeDnsGtmInstanceStatus API
func CreateDescribeDnsGtmInstanceStatusRequest() (request *DescribeDnsGtmInstanceStatusRequest) {
	request = &DescribeDnsGtmInstanceStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "DescribeDnsGtmInstanceStatus", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDnsGtmInstanceStatusResponse creates a response to parse from DescribeDnsGtmInstanceStatus response
func CreateDescribeDnsGtmInstanceStatusResponse() (response *DescribeDnsGtmInstanceStatusResponse) {
	response = &DescribeDnsGtmInstanceStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
