package alimt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// Translate invokes the alimt.Translate API synchronously
func (client *Client) Translate(request *TranslateRequest) (response *TranslateResponse, err error) {
	response = CreateTranslateResponse()
	err = client.DoAction(request, response)
	return
}

// TranslateWithChan invokes the alimt.Translate API asynchronously
func (client *Client) TranslateWithChan(request *TranslateRequest) (<-chan *TranslateResponse, <-chan error) {
	responseChan := make(chan *TranslateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.Translate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TranslateWithCallback invokes the alimt.Translate API asynchronously
func (client *Client) TranslateWithCallback(request *TranslateRequest, callback func(response *TranslateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TranslateResponse
		var err error
		defer close(result)
		response, err = client.Translate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TranslateRequest is the request struct for api Translate
type TranslateRequest struct {
	*requests.RpcRequest
	SourceLanguage string `position:"Body" name:"SourceLanguage"`
	SourceText     string `position:"Body" name:"SourceText"`
	FormatType     string `position:"Body" name:"FormatType"`
	Scene          string `position:"Body" name:"Scene"`
	Context        string `position:"Query" name:"Context"`
	TargetLanguage string `position:"Body" name:"TargetLanguage"`
}

// TranslateResponse is the response struct for api Translate
type TranslateResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateTranslateRequest creates a request to invoke Translate API
func CreateTranslateRequest() (request *TranslateRequest) {
	request = &TranslateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alimt", "2018-10-12", "Translate", "", "")
	request.Method = requests.POST
	return
}

// CreateTranslateResponse creates a response to parse from Translate response
func CreateTranslateResponse() (response *TranslateResponse) {
	response = &TranslateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
