package alinlp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetBrandChEcom invokes the alinlp.GetBrandChEcom API synchronously
func (client *Client) GetBrandChEcom(request *GetBrandChEcomRequest) (response *GetBrandChEcomResponse, err error) {
	response = CreateGetBrandChEcomResponse()
	err = client.DoAction(request, response)
	return
}

// GetBrandChEcomWithChan invokes the alinlp.GetBrandChEcom API asynchronously
func (client *Client) GetBrandChEcomWithChan(request *GetBrandChEcomRequest) (<-chan *GetBrandChEcomResponse, <-chan error) {
	responseChan := make(chan *GetBrandChEcomResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetBrandChEcom(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetBrandChEcomWithCallback invokes the alinlp.GetBrandChEcom API asynchronously
func (client *Client) GetBrandChEcomWithCallback(request *GetBrandChEcomRequest, callback func(response *GetBrandChEcomResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetBrandChEcomResponse
		var err error
		defer close(result)
		response, err = client.GetBrandChEcom(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetBrandChEcomRequest is the request struct for api GetBrandChEcom
type GetBrandChEcomRequest struct {
	*requests.RpcRequest
	ServiceCode string `position:"Body" name:"ServiceCode"`
	ImageUrl    string `position:"Body" name:"ImageUrl"`
	Text        string `position:"Body" name:"Text"`
}

// GetBrandChEcomResponse is the response struct for api GetBrandChEcom
type GetBrandChEcomResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetBrandChEcomRequest creates a request to invoke GetBrandChEcom API
func CreateGetBrandChEcomRequest() (request *GetBrandChEcomRequest) {
	request = &GetBrandChEcomRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alinlp", "2020-06-29", "GetBrandChEcom", "alinlp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetBrandChEcomResponse creates a response to parse from GetBrandChEcom response
func CreateGetBrandChEcomResponse() (response *GetBrandChEcomResponse) {
	response = &GetBrandChEcomResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
