package amp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEdgeMachineModels invokes the amp.DescribeEdgeMachineModels API synchronously
func (client *Client) DescribeEdgeMachineModels(request *DescribeEdgeMachineModelsRequest) (response *DescribeEdgeMachineModelsResponse, err error) {
	response = CreateDescribeEdgeMachineModelsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEdgeMachineModelsWithChan invokes the amp.DescribeEdgeMachineModels API asynchronously
func (client *Client) DescribeEdgeMachineModelsWithChan(request *DescribeEdgeMachineModelsRequest) (<-chan *DescribeEdgeMachineModelsResponse, <-chan error) {
	responseChan := make(chan *DescribeEdgeMachineModelsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEdgeMachineModels(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEdgeMachineModelsWithCallback invokes the amp.DescribeEdgeMachineModels API asynchronously
func (client *Client) DescribeEdgeMachineModelsWithCallback(request *DescribeEdgeMachineModelsRequest, callback func(response *DescribeEdgeMachineModelsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEdgeMachineModelsResponse
		var err error
		defer close(result)
		response, err = client.DescribeEdgeMachineModels(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEdgeMachineModelsRequest is the request struct for api DescribeEdgeMachineModels
type DescribeEdgeMachineModelsRequest struct {
	*requests.RoaRequest
	RRFEW string `position:"Query" name:"RRFEW"`
}

// DescribeEdgeMachineModelsResponse is the response struct for api DescribeEdgeMachineModels
type DescribeEdgeMachineModelsResponse struct {
	*responses.BaseResponse
	Models []ModelsInfo `json:"models" xml:"models"`
}

// CreateDescribeEdgeMachineModelsRequest creates a request to invoke DescribeEdgeMachineModels API
func CreateDescribeEdgeMachineModelsRequest() (request *DescribeEdgeMachineModelsRequest) {
	request = &DescribeEdgeMachineModelsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("amp", "2020-07-08", "DescribeEdgeMachineModels", "/edge_machines/models", "ServiceCode", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeEdgeMachineModelsResponse creates a response to parse from DescribeEdgeMachineModels response
func CreateDescribeEdgeMachineModelsResponse() (response *DescribeEdgeMachineModelsResponse) {
	response = &DescribeEdgeMachineModelsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
