package amqp_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAccount invokes the amqp_open.DeleteAccount API synchronously
func (client *Client) DeleteAccount(request *DeleteAccountRequest) (response *DeleteAccountResponse, err error) {
	response = CreateDeleteAccountResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAccountWithChan invokes the amqp_open.DeleteAccount API asynchronously
func (client *Client) DeleteAccountWithChan(request *DeleteAccountRequest) (<-chan *DeleteAccountResponse, <-chan error) {
	responseChan := make(chan *DeleteAccountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAccount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAccountWithCallback invokes the amqp_open.DeleteAccount API asynchronously
func (client *Client) DeleteAccountWithCallback(request *DeleteAccountRequest, callback func(response *DeleteAccountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAccountResponse
		var err error
		defer close(result)
		response, err = client.DeleteAccount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAccountRequest is the request struct for api DeleteAccount
type DeleteAccountRequest struct {
	*requests.RpcRequest
	CreateTimestamp requests.Integer `position:"Query" name:"CreateTimestamp"`
	UserName        string           `position:"Query" name:"UserName"`
}

// DeleteAccountResponse is the response struct for api DeleteAccount
type DeleteAccountResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      bool   `json:"Data" xml:"Data"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateDeleteAccountRequest creates a request to invoke DeleteAccount API
func CreateDeleteAccountRequest() (request *DeleteAccountRequest) {
	request = &DeleteAccountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("amqp-open", "2019-12-12", "DeleteAccount", "onsproxy", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteAccountResponse creates a response to parse from DeleteAccount response
func CreateDeleteAccountResponse() (response *DeleteAccountResponse) {
	response = &DeleteAccountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
