package antiddos_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeIpDdosThreshold invokes the antiddos_public.DescribeIpDdosThreshold API synchronously
func (client *Client) DescribeIpDdosThreshold(request *DescribeIpDdosThresholdRequest) (response *DescribeIpDdosThresholdResponse, err error) {
	response = CreateDescribeIpDdosThresholdResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeIpDdosThresholdWithChan invokes the antiddos_public.DescribeIpDdosThreshold API asynchronously
func (client *Client) DescribeIpDdosThresholdWithChan(request *DescribeIpDdosThresholdRequest) (<-chan *DescribeIpDdosThresholdResponse, <-chan error) {
	responseChan := make(chan *DescribeIpDdosThresholdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeIpDdosThreshold(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeIpDdosThresholdWithCallback invokes the antiddos_public.DescribeIpDdosThreshold API asynchronously
func (client *Client) DescribeIpDdosThresholdWithCallback(request *DescribeIpDdosThresholdRequest, callback func(response *DescribeIpDdosThresholdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeIpDdosThresholdResponse
		var err error
		defer close(result)
		response, err = client.DescribeIpDdosThreshold(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeIpDdosThresholdRequest is the request struct for api DescribeIpDdosThreshold
type DescribeIpDdosThresholdRequest struct {
	*requests.RpcRequest
	InternetIp   string `position:"Query" name:"InternetIp"`
	DdosType     string `position:"Query" name:"DdosType"`
	SourceIp     string `position:"Query" name:"SourceIp"`
	DdosRegionId string `position:"Query" name:"DdosRegionId"`
	InstanceType string `position:"Query" name:"InstanceType"`
	Lang         string `position:"Query" name:"Lang"`
	InstanceId   string `position:"Query" name:"InstanceId"`
}

// DescribeIpDdosThresholdResponse is the response struct for api DescribeIpDdosThreshold
type DescribeIpDdosThresholdResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	Threshold Threshold `json:"Threshold" xml:"Threshold"`
}

// CreateDescribeIpDdosThresholdRequest creates a request to invoke DescribeIpDdosThreshold API
func CreateDescribeIpDdosThresholdRequest() (request *DescribeIpDdosThresholdRequest) {
	request = &DescribeIpDdosThresholdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("antiddos-public", "2017-05-18", "DescribeIpDdosThreshold", "ddosbasic", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeIpDdosThresholdResponse creates a response to parse from DescribeIpDdosThreshold response
func CreateDescribeIpDdosThresholdResponse() (response *DescribeIpDdosThresholdResponse) {
	response = &DescribeIpDdosThresholdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
