package appstream_center

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ApproveOtaTask invokes the appstream_center.ApproveOtaTask API synchronously
func (client *Client) ApproveOtaTask(request *ApproveOtaTaskRequest) (response *ApproveOtaTaskResponse, err error) {
	response = CreateApproveOtaTaskResponse()
	err = client.DoAction(request, response)
	return
}

// ApproveOtaTaskWithChan invokes the appstream_center.ApproveOtaTask API asynchronously
func (client *Client) ApproveOtaTaskWithChan(request *ApproveOtaTaskRequest) (<-chan *ApproveOtaTaskResponse, <-chan error) {
	responseChan := make(chan *ApproveOtaTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ApproveOtaTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ApproveOtaTaskWithCallback invokes the appstream_center.ApproveOtaTask API asynchronously
func (client *Client) ApproveOtaTaskWithCallback(request *ApproveOtaTaskRequest, callback func(response *ApproveOtaTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ApproveOtaTaskResponse
		var err error
		defer close(result)
		response, err = client.ApproveOtaTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ApproveOtaTaskRequest is the request struct for api ApproveOtaTask
type ApproveOtaTaskRequest struct {
	*requests.RpcRequest
	BizRegionId        string `position:"Body" name:"BizRegionId"`
	OtaType            string `position:"Body" name:"OtaType"`
	StartTime          string `position:"Body" name:"StartTime"`
	StopTime           string `position:"Body" name:"StopTime"`
	AppInstanceGroupId string `position:"Body" name:"AppInstanceGroupId"`
	TaskId             string `position:"Body" name:"TaskId"`
}

// ApproveOtaTaskResponse is the response struct for api ApproveOtaTask
type ApproveOtaTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateApproveOtaTaskRequest creates a request to invoke ApproveOtaTask API
func CreateApproveOtaTaskRequest() (request *ApproveOtaTaskRequest) {
	request = &ApproveOtaTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("appstream-center", "2021-09-01", "ApproveOtaTask", "", "")
	request.Method = requests.POST
	return
}

// CreateApproveOtaTaskResponse creates a response to parse from ApproveOtaTask response
func CreateApproveOtaTaskResponse() (response *ApproveOtaTaskResponse) {
	response = &ApproveOtaTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
