package appstream_center

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CancelOtaTask invokes the appstream_center.CancelOtaTask API synchronously
func (client *Client) CancelOtaTask(request *CancelOtaTaskRequest) (response *CancelOtaTaskResponse, err error) {
	response = CreateCancelOtaTaskResponse()
	err = client.DoAction(request, response)
	return
}

// CancelOtaTaskWithChan invokes the appstream_center.CancelOtaTask API asynchronously
func (client *Client) CancelOtaTaskWithChan(request *CancelOtaTaskRequest) (<-chan *CancelOtaTaskResponse, <-chan error) {
	responseChan := make(chan *CancelOtaTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CancelOtaTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CancelOtaTaskWithCallback invokes the appstream_center.CancelOtaTask API asynchronously
func (client *Client) CancelOtaTaskWithCallback(request *CancelOtaTaskRequest, callback func(response *CancelOtaTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CancelOtaTaskResponse
		var err error
		defer close(result)
		response, err = client.CancelOtaTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CancelOtaTaskRequest is the request struct for api CancelOtaTask
type CancelOtaTaskRequest struct {
	*requests.RpcRequest
	AppInstanceGroupId string `position:"Body" name:"AppInstanceGroupId"`
	TaskId             string `position:"Body" name:"TaskId"`
}

// CancelOtaTaskResponse is the response struct for api CancelOtaTask
type CancelOtaTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateCancelOtaTaskRequest creates a request to invoke CancelOtaTask API
func CreateCancelOtaTaskRequest() (request *CancelOtaTaskRequest) {
	request = &CancelOtaTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("appstream-center", "2021-09-01", "CancelOtaTask", "", "")
	request.Method = requests.POST
	return
}

// CreateCancelOtaTaskResponse creates a response to parse from CancelOtaTask response
func CreateCancelOtaTaskResponse() (response *CancelOtaTaskResponse) {
	response = &CancelOtaTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
