package appstream_center

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAppInstances invokes the appstream_center.DeleteAppInstances API synchronously
func (client *Client) DeleteAppInstances(request *DeleteAppInstancesRequest) (response *DeleteAppInstancesResponse, err error) {
	response = CreateDeleteAppInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAppInstancesWithChan invokes the appstream_center.DeleteAppInstances API asynchronously
func (client *Client) DeleteAppInstancesWithChan(request *DeleteAppInstancesRequest) (<-chan *DeleteAppInstancesResponse, <-chan error) {
	responseChan := make(chan *DeleteAppInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAppInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAppInstancesWithCallback invokes the appstream_center.DeleteAppInstances API asynchronously
func (client *Client) DeleteAppInstancesWithCallback(request *DeleteAppInstancesRequest, callback func(response *DeleteAppInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAppInstancesResponse
		var err error
		defer close(result)
		response, err = client.DeleteAppInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAppInstancesRequest is the request struct for api DeleteAppInstances
type DeleteAppInstancesRequest struct {
	*requests.RpcRequest
	AppInstanceIds     *[]string `position:"Body" name:"AppInstanceIds"  type:"Repeated"`
	ProductType        string    `position:"Body" name:"ProductType"`
	AppInstanceGroupId string    `position:"Body" name:"AppInstanceGroupId"`
}

// DeleteAppInstancesResponse is the response struct for api DeleteAppInstances
type DeleteAppInstancesResponse struct {
	*responses.BaseResponse
	RequestId               string `json:"RequestId" xml:"RequestId"`
	DeleteAppInstanceModels []Data `json:"DeleteAppInstanceModels" xml:"DeleteAppInstanceModels"`
}

// CreateDeleteAppInstancesRequest creates a request to invoke DeleteAppInstances API
func CreateDeleteAppInstancesRequest() (request *DeleteAppInstancesRequest) {
	request = &DeleteAppInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("appstream-center", "2021-09-01", "DeleteAppInstances", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteAppInstancesResponse creates a response to parse from DeleteAppInstances response
func CreateDeleteAppInstancesResponse() (response *DeleteAppInstancesResponse) {
	response = &DeleteAppInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
