package appstream_center

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// Unbind invokes the appstream_center.Unbind API synchronously
func (client *Client) Unbind(request *UnbindRequest) (response *UnbindResponse, err error) {
	response = CreateUnbindResponse()
	err = client.DoAction(request, response)
	return
}

// UnbindWithChan invokes the appstream_center.Unbind API asynchronously
func (client *Client) UnbindWithChan(request *UnbindRequest) (<-chan *UnbindResponse, <-chan error) {
	responseChan := make(chan *UnbindResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.Unbind(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnbindWithCallback invokes the appstream_center.Unbind API asynchronously
func (client *Client) UnbindWithCallback(request *UnbindRequest, callback func(response *UnbindResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnbindResponse
		var err error
		defer close(result)
		response, err = client.Unbind(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnbindRequest is the request struct for api Unbind
type UnbindRequest struct {
	*requests.RpcRequest
	ProductType        string `position:"Body" name:"ProductType"`
	AppInstanceGroupId string `position:"Body" name:"AppInstanceGroupId"`
	EndUserId          string `position:"Body" name:"EndUserId"`
	AppInstanceId      string `position:"Body" name:"AppInstanceId"`
}

// UnbindResponse is the response struct for api Unbind
type UnbindResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUnbindRequest creates a request to invoke Unbind API
func CreateUnbindRequest() (request *UnbindRequest) {
	request = &UnbindRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("appstream-center", "2021-09-01", "Unbind", "", "")
	request.Method = requests.POST
	return
}

// CreateUnbindResponse creates a response to parse from Unbind response
func CreateUnbindResponse() (response *UnbindResponse) {
	response = &UnbindResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
