package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeletePrometheusIntegration invokes the arms.DeletePrometheusIntegration API synchronously
func (client *Client) DeletePrometheusIntegration(request *DeletePrometheusIntegrationRequest) (response *DeletePrometheusIntegrationResponse, err error) {
	response = CreateDeletePrometheusIntegrationResponse()
	err = client.DoAction(request, response)
	return
}

// DeletePrometheusIntegrationWithChan invokes the arms.DeletePrometheusIntegration API asynchronously
func (client *Client) DeletePrometheusIntegrationWithChan(request *DeletePrometheusIntegrationRequest) (<-chan *DeletePrometheusIntegrationResponse, <-chan error) {
	responseChan := make(chan *DeletePrometheusIntegrationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeletePrometheusIntegration(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeletePrometheusIntegrationWithCallback invokes the arms.DeletePrometheusIntegration API asynchronously
func (client *Client) DeletePrometheusIntegrationWithCallback(request *DeletePrometheusIntegrationRequest, callback func(response *DeletePrometheusIntegrationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeletePrometheusIntegrationResponse
		var err error
		defer close(result)
		response, err = client.DeletePrometheusIntegration(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeletePrometheusIntegrationRequest is the request struct for api DeletePrometheusIntegration
type DeletePrometheusIntegrationRequest struct {
	*requests.RpcRequest
	InstanceId      requests.Integer `position:"Query" name:"InstanceId"`
	IntegrationType string           `position:"Query" name:"IntegrationType"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
}

// DeletePrometheusIntegrationResponse is the response struct for api DeletePrometheusIntegration
type DeletePrometheusIntegrationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
	Message   string `json:"Message" xml:"Message"`
	Code      int    `json:"Code" xml:"Code"`
}

// CreateDeletePrometheusIntegrationRequest creates a request to invoke DeletePrometheusIntegration API
func CreateDeletePrometheusIntegrationRequest() (request *DeletePrometheusIntegrationRequest) {
	request = &DeletePrometheusIntegrationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "DeletePrometheusIntegration", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeletePrometheusIntegrationResponse creates a response to parse from DeletePrometheusIntegration response
func CreateDeletePrometheusIntegrationResponse() (response *DeletePrometheusIntegrationResponse) {
	response = &DeletePrometheusIntegrationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
