package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPrometheusRemoteWrite invokes the arms.GetPrometheusRemoteWrite API synchronously
func (client *Client) GetPrometheusRemoteWrite(request *GetPrometheusRemoteWriteRequest) (response *GetPrometheusRemoteWriteResponse, err error) {
	response = CreateGetPrometheusRemoteWriteResponse()
	err = client.DoAction(request, response)
	return
}

// GetPrometheusRemoteWriteWithChan invokes the arms.GetPrometheusRemoteWrite API asynchronously
func (client *Client) GetPrometheusRemoteWriteWithChan(request *GetPrometheusRemoteWriteRequest) (<-chan *GetPrometheusRemoteWriteResponse, <-chan error) {
	responseChan := make(chan *GetPrometheusRemoteWriteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPrometheusRemoteWrite(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPrometheusRemoteWriteWithCallback invokes the arms.GetPrometheusRemoteWrite API asynchronously
func (client *Client) GetPrometheusRemoteWriteWithCallback(request *GetPrometheusRemoteWriteRequest, callback func(response *GetPrometheusRemoteWriteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPrometheusRemoteWriteResponse
		var err error
		defer close(result)
		response, err = client.GetPrometheusRemoteWrite(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPrometheusRemoteWriteRequest is the request struct for api GetPrometheusRemoteWrite
type GetPrometheusRemoteWriteRequest struct {
	*requests.RpcRequest
	ClusterId       string `position:"Query" name:"ClusterId"`
	RemoteWriteName string `position:"Query" name:"RemoteWriteName"`
}

// GetPrometheusRemoteWriteResponse is the response struct for api GetPrometheusRemoteWrite
type GetPrometheusRemoteWriteResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Code      int    `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetPrometheusRemoteWriteRequest creates a request to invoke GetPrometheusRemoteWrite API
func CreateGetPrometheusRemoteWriteRequest() (request *GetPrometheusRemoteWriteRequest) {
	request = &GetPrometheusRemoteWriteRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "GetPrometheusRemoteWrite", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetPrometheusRemoteWriteResponse creates a response to parse from GetPrometheusRemoteWrite response
func CreateGetPrometheusRemoteWriteResponse() (response *GetPrometheusRemoteWriteResponse) {
	response = &GetPrometheusRemoteWriteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
