package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateTransitRouterMulticastDomain invokes the cbn.CreateTransitRouterMulticastDomain API synchronously
func (client *Client) CreateTransitRouterMulticastDomain(request *CreateTransitRouterMulticastDomainRequest) (response *CreateTransitRouterMulticastDomainResponse, err error) {
	response = CreateCreateTransitRouterMulticastDomainResponse()
	err = client.DoAction(request, response)
	return
}

// CreateTransitRouterMulticastDomainWithChan invokes the cbn.CreateTransitRouterMulticastDomain API asynchronously
func (client *Client) CreateTransitRouterMulticastDomainWithChan(request *CreateTransitRouterMulticastDomainRequest) (<-chan *CreateTransitRouterMulticastDomainResponse, <-chan error) {
	responseChan := make(chan *CreateTransitRouterMulticastDomainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateTransitRouterMulticastDomain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTransitRouterMulticastDomainWithCallback invokes the cbn.CreateTransitRouterMulticastDomain API asynchronously
func (client *Client) CreateTransitRouterMulticastDomainWithCallback(request *CreateTransitRouterMulticastDomainRequest, callback func(response *CreateTransitRouterMulticastDomainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTransitRouterMulticastDomainResponse
		var err error
		defer close(result)
		response, err = client.CreateTransitRouterMulticastDomain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTransitRouterMulticastDomainRequest is the request struct for api CreateTransitRouterMulticastDomain
type CreateTransitRouterMulticastDomainRequest struct {
	*requests.RpcRequest
	ResourceOwnerId                         requests.Integer                         `position:"Query" name:"ResourceOwnerId"`
	ClientToken                             string                                   `position:"Query" name:"ClientToken"`
	CenId                                   string                                   `position:"Query" name:"CenId"`
	MulticastType                           string                                   `position:"Query" name:"MulticastType"`
	TransitRouterMulticastDomainDescription string                                   `position:"Query" name:"TransitRouterMulticastDomainDescription"`
	TransitRouterMulticastDomainName        string                                   `position:"Query" name:"TransitRouterMulticastDomainName"`
	Tag                                     *[]CreateTransitRouterMulticastDomainTag `position:"Query" name:"Tag"  type:"Repeated"`
	DryRun                                  requests.Boolean                         `position:"Query" name:"DryRun"`
	ResourceOwnerAccount                    string                                   `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount                            string                                   `position:"Query" name:"OwnerAccount"`
	OwnerId                                 requests.Integer                         `position:"Query" name:"OwnerId"`
	TransitRouterId                         string                                   `position:"Query" name:"TransitRouterId"`
	Version                                 string                                   `position:"Query" name:"Version"`
}

// CreateTransitRouterMulticastDomainTag is a repeated param struct in CreateTransitRouterMulticastDomainRequest
type CreateTransitRouterMulticastDomainTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// CreateTransitRouterMulticastDomainResponse is the response struct for api CreateTransitRouterMulticastDomain
type CreateTransitRouterMulticastDomainResponse struct {
	*responses.BaseResponse
	TransitRouterMulticastDomainId string `json:"TransitRouterMulticastDomainId" xml:"TransitRouterMulticastDomainId"`
	RequestId                      string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateTransitRouterMulticastDomainRequest creates a request to invoke CreateTransitRouterMulticastDomain API
func CreateCreateTransitRouterMulticastDomainRequest() (request *CreateTransitRouterMulticastDomainRequest) {
	request = &CreateTransitRouterMulticastDomainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "CreateTransitRouterMulticastDomain", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateTransitRouterMulticastDomainResponse creates a response to parse from CreateTransitRouterMulticastDomain response
func CreateCreateTransitRouterMulticastDomainResponse() (response *CreateTransitRouterMulticastDomainResponse) {
	response = &CreateTransitRouterMulticastDomainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
