package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableCenVbrHealthCheck invokes the cbn.DisableCenVbrHealthCheck API synchronously
func (client *Client) DisableCenVbrHealthCheck(request *DisableCenVbrHealthCheckRequest) (response *DisableCenVbrHealthCheckResponse, err error) {
	response = CreateDisableCenVbrHealthCheckResponse()
	err = client.DoAction(request, response)
	return
}

// DisableCenVbrHealthCheckWithChan invokes the cbn.DisableCenVbrHealthCheck API asynchronously
func (client *Client) DisableCenVbrHealthCheckWithChan(request *DisableCenVbrHealthCheckRequest) (<-chan *DisableCenVbrHealthCheckResponse, <-chan error) {
	responseChan := make(chan *DisableCenVbrHealthCheckResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableCenVbrHealthCheck(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableCenVbrHealthCheckWithCallback invokes the cbn.DisableCenVbrHealthCheck API asynchronously
func (client *Client) DisableCenVbrHealthCheckWithCallback(request *DisableCenVbrHealthCheckRequest, callback func(response *DisableCenVbrHealthCheckResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableCenVbrHealthCheckResponse
		var err error
		defer close(result)
		response, err = client.DisableCenVbrHealthCheck(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableCenVbrHealthCheckRequest is the request struct for api DisableCenVbrHealthCheck
type DisableCenVbrHealthCheckRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CenId                string           `position:"Query" name:"CenId"`
	VbrInstanceOwnerId   requests.Integer `position:"Query" name:"VbrInstanceOwnerId"`
	VbrInstanceRegionId  string           `position:"Query" name:"VbrInstanceRegionId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Version              string           `position:"Query" name:"Version"`
	VbrInstanceId        string           `position:"Query" name:"VbrInstanceId"`
}

// DisableCenVbrHealthCheckResponse is the response struct for api DisableCenVbrHealthCheck
type DisableCenVbrHealthCheckResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDisableCenVbrHealthCheckRequest creates a request to invoke DisableCenVbrHealthCheck API
func CreateDisableCenVbrHealthCheckRequest() (request *DisableCenVbrHealthCheckRequest) {
	request = &DisableCenVbrHealthCheckRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "DisableCenVbrHealthCheck", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDisableCenVbrHealthCheckResponse creates a response to parse from DisableCenVbrHealthCheck response
func CreateDisableCenVbrHealthCheckResponse() (response *DisableCenVbrHealthCheckResponse) {
	response = &DisableCenVbrHealthCheckResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
