package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateCenInterRegionTrafficQosQueueAttribute invokes the cbn.UpdateCenInterRegionTrafficQosQueueAttribute API synchronously
func (client *Client) UpdateCenInterRegionTrafficQosQueueAttribute(request *UpdateCenInterRegionTrafficQosQueueAttributeRequest) (response *UpdateCenInterRegionTrafficQosQueueAttributeResponse, err error) {
	response = CreateUpdateCenInterRegionTrafficQosQueueAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateCenInterRegionTrafficQosQueueAttributeWithChan invokes the cbn.UpdateCenInterRegionTrafficQosQueueAttribute API asynchronously
func (client *Client) UpdateCenInterRegionTrafficQosQueueAttributeWithChan(request *UpdateCenInterRegionTrafficQosQueueAttributeRequest) (<-chan *UpdateCenInterRegionTrafficQosQueueAttributeResponse, <-chan error) {
	responseChan := make(chan *UpdateCenInterRegionTrafficQosQueueAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateCenInterRegionTrafficQosQueueAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateCenInterRegionTrafficQosQueueAttributeWithCallback invokes the cbn.UpdateCenInterRegionTrafficQosQueueAttribute API asynchronously
func (client *Client) UpdateCenInterRegionTrafficQosQueueAttributeWithCallback(request *UpdateCenInterRegionTrafficQosQueueAttributeRequest, callback func(response *UpdateCenInterRegionTrafficQosQueueAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateCenInterRegionTrafficQosQueueAttributeResponse
		var err error
		defer close(result)
		response, err = client.UpdateCenInterRegionTrafficQosQueueAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateCenInterRegionTrafficQosQueueAttributeRequest is the request struct for api UpdateCenInterRegionTrafficQosQueueAttribute
type UpdateCenInterRegionTrafficQosQueueAttributeRequest struct {
	*requests.RpcRequest
	Dscps                  *[]string        `position:"Query" name:"Dscps"  type:"Repeated"`
	ResourceOwnerId        requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken            string           `position:"Query" name:"ClientToken"`
	QosQueueName           string           `position:"Query" name:"QosQueueName"`
	RemainBandwidthPercent string           `position:"Query" name:"RemainBandwidthPercent"`
	DryRun                 requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount   string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount           string           `position:"Query" name:"OwnerAccount"`
	OwnerId                requests.Integer `position:"Query" name:"OwnerId"`
	Version                string           `position:"Query" name:"Version"`
	QosQueueId             string           `position:"Query" name:"QosQueueId"`
	QosQueueDescription    string           `position:"Query" name:"QosQueueDescription"`
}

// UpdateCenInterRegionTrafficQosQueueAttributeResponse is the response struct for api UpdateCenInterRegionTrafficQosQueueAttribute
type UpdateCenInterRegionTrafficQosQueueAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateCenInterRegionTrafficQosQueueAttributeRequest creates a request to invoke UpdateCenInterRegionTrafficQosQueueAttribute API
func CreateUpdateCenInterRegionTrafficQosQueueAttributeRequest() (request *UpdateCenInterRegionTrafficQosQueueAttributeRequest) {
	request = &UpdateCenInterRegionTrafficQosQueueAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "UpdateCenInterRegionTrafficQosQueueAttribute", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateCenInterRegionTrafficQosQueueAttributeResponse creates a response to parse from UpdateCenInterRegionTrafficQosQueueAttribute response
func CreateUpdateCenInterRegionTrafficQosQueueAttributeResponse() (response *UpdateCenInterRegionTrafficQosQueueAttributeResponse) {
	response = &UpdateCenInterRegionTrafficQosQueueAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
