package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateTransitRouterVpnAttachmentAttribute invokes the cbn.UpdateTransitRouterVpnAttachmentAttribute API synchronously
func (client *Client) UpdateTransitRouterVpnAttachmentAttribute(request *UpdateTransitRouterVpnAttachmentAttributeRequest) (response *UpdateTransitRouterVpnAttachmentAttributeResponse, err error) {
	response = CreateUpdateTransitRouterVpnAttachmentAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateTransitRouterVpnAttachmentAttributeWithChan invokes the cbn.UpdateTransitRouterVpnAttachmentAttribute API asynchronously
func (client *Client) UpdateTransitRouterVpnAttachmentAttributeWithChan(request *UpdateTransitRouterVpnAttachmentAttributeRequest) (<-chan *UpdateTransitRouterVpnAttachmentAttributeResponse, <-chan error) {
	responseChan := make(chan *UpdateTransitRouterVpnAttachmentAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateTransitRouterVpnAttachmentAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateTransitRouterVpnAttachmentAttributeWithCallback invokes the cbn.UpdateTransitRouterVpnAttachmentAttribute API asynchronously
func (client *Client) UpdateTransitRouterVpnAttachmentAttributeWithCallback(request *UpdateTransitRouterVpnAttachmentAttributeRequest, callback func(response *UpdateTransitRouterVpnAttachmentAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateTransitRouterVpnAttachmentAttributeResponse
		var err error
		defer close(result)
		response, err = client.UpdateTransitRouterVpnAttachmentAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateTransitRouterVpnAttachmentAttributeRequest is the request struct for api UpdateTransitRouterVpnAttachmentAttribute
type UpdateTransitRouterVpnAttachmentAttributeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId                    requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken                        string           `position:"Query" name:"ClientToken"`
	TransitRouterAttachmentName        string           `position:"Query" name:"TransitRouterAttachmentName"`
	AutoPublishRouteEnabled            requests.Boolean `position:"Query" name:"AutoPublishRouteEnabled"`
	DryRun                             requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount               string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount                       string           `position:"Query" name:"OwnerAccount"`
	OwnerId                            requests.Integer `position:"Query" name:"OwnerId"`
	ResourceType                       string           `position:"Query" name:"ResourceType"`
	Version                            string           `position:"Query" name:"Version"`
	TransitRouterAttachmentId          string           `position:"Query" name:"TransitRouterAttachmentId"`
	TransitRouterAttachmentDescription string           `position:"Query" name:"TransitRouterAttachmentDescription"`
}

// UpdateTransitRouterVpnAttachmentAttributeResponse is the response struct for api UpdateTransitRouterVpnAttachmentAttribute
type UpdateTransitRouterVpnAttachmentAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateTransitRouterVpnAttachmentAttributeRequest creates a request to invoke UpdateTransitRouterVpnAttachmentAttribute API
func CreateUpdateTransitRouterVpnAttachmentAttributeRequest() (request *UpdateTransitRouterVpnAttachmentAttributeRequest) {
	request = &UpdateTransitRouterVpnAttachmentAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "UpdateTransitRouterVpnAttachmentAttribute", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateTransitRouterVpnAttachmentAttributeResponse creates a response to parse from UpdateTransitRouterVpnAttachmentAttribute response
func CreateUpdateTransitRouterVpnAttachmentAttributeResponse() (response *UpdateTransitRouterVpnAttachmentAttributeResponse) {
	response = &UpdateTransitRouterVpnAttachmentAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
