package cc5g

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCreateCustomerInformation invokes the cc5g.GetCreateCustomerInformation API synchronously
func (client *Client) GetCreateCustomerInformation(request *GetCreateCustomerInformationRequest) (response *GetCreateCustomerInformationResponse, err error) {
	response = CreateGetCreateCustomerInformationResponse()
	err = client.DoAction(request, response)
	return
}

// GetCreateCustomerInformationWithChan invokes the cc5g.GetCreateCustomerInformation API asynchronously
func (client *Client) GetCreateCustomerInformationWithChan(request *GetCreateCustomerInformationRequest) (<-chan *GetCreateCustomerInformationResponse, <-chan error) {
	responseChan := make(chan *GetCreateCustomerInformationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCreateCustomerInformation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCreateCustomerInformationWithCallback invokes the cc5g.GetCreateCustomerInformation API asynchronously
func (client *Client) GetCreateCustomerInformationWithCallback(request *GetCreateCustomerInformationRequest, callback func(response *GetCreateCustomerInformationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCreateCustomerInformationResponse
		var err error
		defer close(result)
		response, err = client.GetCreateCustomerInformation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCreateCustomerInformationRequest is the request struct for api GetCreateCustomerInformation
type GetCreateCustomerInformationRequest struct {
	*requests.RpcRequest
	WirelessCloudConnectorId string `position:"Query" name:"WirelessCloudConnectorId"`
}

// GetCreateCustomerInformationResponse is the response struct for api GetCreateCustomerInformation
type GetCreateCustomerInformationResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	URL        string `json:"URL" xml:"URL"`
	CanBuyCard string `json:"CanBuyCard" xml:"CanBuyCard"`
}

// CreateGetCreateCustomerInformationRequest creates a request to invoke GetCreateCustomerInformation API
func CreateGetCreateCustomerInformationRequest() (request *GetCreateCustomerInformationRequest) {
	request = &GetCreateCustomerInformationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CC5G", "2022-03-14", "GetCreateCustomerInformation", "fivegcc", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetCreateCustomerInformationResponse creates a response to parse from GetCreateCustomerInformation response
func CreateGetCreateCustomerInformationResponse() (response *GetCreateCustomerInformationResponse) {
	response = &GetCreateCustomerInformationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
