package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BlindTransfer invokes the ccc.BlindTransfer API synchronously
func (client *Client) BlindTransfer(request *BlindTransferRequest) (response *BlindTransferResponse, err error) {
	response = CreateBlindTransferResponse()
	err = client.DoAction(request, response)
	return
}

// BlindTransferWithChan invokes the ccc.BlindTransfer API asynchronously
func (client *Client) BlindTransferWithChan(request *BlindTransferRequest) (<-chan *BlindTransferResponse, <-chan error) {
	responseChan := make(chan *BlindTransferResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BlindTransfer(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BlindTransferWithCallback invokes the ccc.BlindTransfer API asynchronously
func (client *Client) BlindTransferWithCallback(request *BlindTransferRequest, callback func(response *BlindTransferResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BlindTransferResponse
		var err error
		defer close(result)
		response, err = client.BlindTransfer(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BlindTransferRequest is the request struct for api BlindTransfer
type BlindTransferRequest struct {
	*requests.RpcRequest
	Transferee     string           `position:"Query" name:"Transferee"`
	Transferor     string           `position:"Query" name:"Transferor"`
	UserId         string           `position:"Query" name:"UserId"`
	DeviceId       string           `position:"Query" name:"DeviceId"`
	StrategyName   string           `position:"Query" name:"StrategyName"`
	TimeoutSeconds requests.Integer `position:"Query" name:"TimeoutSeconds"`
	JobId          string           `position:"Query" name:"JobId"`
	InstanceId     string           `position:"Query" name:"InstanceId"`
	StrategyParams string           `position:"Query" name:"StrategyParams"`
	CallPriority   requests.Integer `position:"Query" name:"CallPriority"`
}

// BlindTransferResponse is the response struct for api BlindTransfer
type BlindTransferResponse struct {
	*responses.BaseResponse
	Code           string   `json:"Code" xml:"Code"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string   `json:"Message" xml:"Message"`
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	Params         []string `json:"Params" xml:"Params"`
	Data           Data     `json:"Data" xml:"Data"`
}

// CreateBlindTransferRequest creates a request to invoke BlindTransfer API
func CreateBlindTransferRequest() (request *BlindTransferRequest) {
	request = &BlindTransferRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "BlindTransfer", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBlindTransferResponse creates a response to parse from BlindTransfer response
func CreateBlindTransferResponse() (response *BlindTransferResponse) {
	response = &BlindTransferResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
