package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAudioFile invokes the ccc.DeleteAudioFile API synchronously
func (client *Client) DeleteAudioFile(request *DeleteAudioFileRequest) (response *DeleteAudioFileResponse, err error) {
	response = CreateDeleteAudioFileResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAudioFileWithChan invokes the ccc.DeleteAudioFile API asynchronously
func (client *Client) DeleteAudioFileWithChan(request *DeleteAudioFileRequest) (<-chan *DeleteAudioFileResponse, <-chan error) {
	responseChan := make(chan *DeleteAudioFileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAudioFile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAudioFileWithCallback invokes the ccc.DeleteAudioFile API asynchronously
func (client *Client) DeleteAudioFileWithCallback(request *DeleteAudioFileRequest, callback func(response *DeleteAudioFileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAudioFileResponse
		var err error
		defer close(result)
		response, err = client.DeleteAudioFile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAudioFileRequest is the request struct for api DeleteAudioFile
type DeleteAudioFileRequest struct {
	*requests.RpcRequest
	InstanceId      string `position:"Query" name:"InstanceId"`
	AudioResourceId string `position:"Query" name:"AudioResourceId"`
}

// DeleteAudioFileResponse is the response struct for api DeleteAudioFile
type DeleteAudioFileResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	Data           string `json:"Data" xml:"Data"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteAudioFileRequest creates a request to invoke DeleteAudioFile API
func CreateDeleteAudioFileRequest() (request *DeleteAudioFileRequest) {
	request = &DeleteAudioFileRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "DeleteAudioFile", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteAudioFileResponse creates a response to parse from DeleteAudioFile response
func CreateDeleteAudioFileResponse() (response *DeleteAudioFileResponse) {
	response = &DeleteAudioFileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
