package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EndConference invokes the ccc.EndConference API synchronously
func (client *Client) EndConference(request *EndConferenceRequest) (response *EndConferenceResponse, err error) {
	response = CreateEndConferenceResponse()
	err = client.DoAction(request, response)
	return
}

// EndConferenceWithChan invokes the ccc.EndConference API asynchronously
func (client *Client) EndConferenceWithChan(request *EndConferenceRequest) (<-chan *EndConferenceResponse, <-chan error) {
	responseChan := make(chan *EndConferenceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EndConference(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EndConferenceWithCallback invokes the ccc.EndConference API asynchronously
func (client *Client) EndConferenceWithCallback(request *EndConferenceRequest, callback func(response *EndConferenceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EndConferenceResponse
		var err error
		defer close(result)
		response, err = client.EndConference(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EndConferenceRequest is the request struct for api EndConference
type EndConferenceRequest struct {
	*requests.RpcRequest
	UserId     string `position:"Query" name:"UserId"`
	JobId      string `position:"Query" name:"JobId"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// EndConferenceResponse is the response struct for api EndConference
type EndConferenceResponse struct {
	*responses.BaseResponse
	Code           string   `json:"Code" xml:"Code"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string   `json:"Message" xml:"Message"`
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	Params         []string `json:"Params" xml:"Params"`
	Data           Data     `json:"Data" xml:"Data"`
}

// CreateEndConferenceRequest creates a request to invoke EndConference API
func CreateEndConferenceRequest() (request *EndConferenceRequest) {
	request = &EndConferenceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "EndConference", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEndConferenceResponse creates a response to parse from EndConference response
func CreateEndConferenceResponse() (response *EndConferenceResponse) {
	response = &EndConferenceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
