package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListIntervalInstanceReport invokes the ccc.ListIntervalInstanceReport API synchronously
func (client *Client) ListIntervalInstanceReport(request *ListIntervalInstanceReportRequest) (response *ListIntervalInstanceReportResponse, err error) {
	response = CreateListIntervalInstanceReportResponse()
	err = client.DoAction(request, response)
	return
}

// ListIntervalInstanceReportWithChan invokes the ccc.ListIntervalInstanceReport API asynchronously
func (client *Client) ListIntervalInstanceReportWithChan(request *ListIntervalInstanceReportRequest) (<-chan *ListIntervalInstanceReportResponse, <-chan error) {
	responseChan := make(chan *ListIntervalInstanceReportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListIntervalInstanceReport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListIntervalInstanceReportWithCallback invokes the ccc.ListIntervalInstanceReport API asynchronously
func (client *Client) ListIntervalInstanceReportWithCallback(request *ListIntervalInstanceReportRequest, callback func(response *ListIntervalInstanceReportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListIntervalInstanceReportResponse
		var err error
		defer close(result)
		response, err = client.ListIntervalInstanceReport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListIntervalInstanceReportRequest is the request struct for api ListIntervalInstanceReport
type ListIntervalInstanceReportRequest struct {
	*requests.RpcRequest
	EndTime    requests.Integer `position:"Query" name:"EndTime"`
	StartTime  requests.Integer `position:"Query" name:"StartTime"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	Interval   string           `position:"Query" name:"Interval"`
}

// ListIntervalInstanceReportResponse is the response struct for api ListIntervalInstanceReport
type ListIntervalInstanceReportResponse struct {
	*responses.BaseResponse
	Code           string     `json:"Code" xml:"Code"`
	HttpStatusCode int        `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string     `json:"Message" xml:"Message"`
	RequestId      string     `json:"RequestId" xml:"RequestId"`
	Data           []DataItem `json:"Data" xml:"Data"`
}

// CreateListIntervalInstanceReportRequest creates a request to invoke ListIntervalInstanceReport API
func CreateListIntervalInstanceReportRequest() (request *ListIntervalInstanceReportRequest) {
	request = &ListIntervalInstanceReportRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "ListIntervalInstanceReport", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListIntervalInstanceReportResponse creates a response to parse from ListIntervalInstanceReport response
func CreateListIntervalInstanceReportResponse() (response *ListIntervalInstanceReportResponse) {
	response = &ListIntervalInstanceReportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
