package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeIpStatus invokes the cdn.DescribeIpStatus API synchronously
func (client *Client) DescribeIpStatus(request *DescribeIpStatusRequest) (response *DescribeIpStatusResponse, err error) {
	response = CreateDescribeIpStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeIpStatusWithChan invokes the cdn.DescribeIpStatus API asynchronously
func (client *Client) DescribeIpStatusWithChan(request *DescribeIpStatusRequest) (<-chan *DescribeIpStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeIpStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeIpStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeIpStatusWithCallback invokes the cdn.DescribeIpStatus API asynchronously
func (client *Client) DescribeIpStatusWithCallback(request *DescribeIpStatusRequest, callback func(response *DescribeIpStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeIpStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeIpStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeIpStatusRequest is the request struct for api DescribeIpStatus
type DescribeIpStatusRequest struct {
	*requests.RpcRequest
	Ips string `position:"Query" name:"Ips"`
}

// DescribeIpStatusResponse is the response struct for api DescribeIpStatus
type DescribeIpStatusResponse struct {
	*responses.BaseResponse
	RequestId string      `json:"RequestId" xml:"RequestId"`
	IpStatus  []UsageData `json:"IpStatus" xml:"IpStatus"`
}

// CreateDescribeIpStatusRequest creates a request to invoke DescribeIpStatus API
func CreateDescribeIpStatusRequest() (request *DescribeIpStatusRequest) {
	request = &DescribeIpStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "DescribeIpStatus", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeIpStatusResponse creates a response to parse from DescribeIpStatus response
func CreateDescribeIpStatusResponse() (response *DescribeIpStatusResponse) {
	response = &DescribeIpStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
