package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// VerifyDomainOwner invokes the cdn.VerifyDomainOwner API synchronously
func (client *Client) VerifyDomainOwner(request *VerifyDomainOwnerRequest) (response *VerifyDomainOwnerResponse, err error) {
	response = CreateVerifyDomainOwnerResponse()
	err = client.DoAction(request, response)
	return
}

// VerifyDomainOwnerWithChan invokes the cdn.VerifyDomainOwner API asynchronously
func (client *Client) VerifyDomainOwnerWithChan(request *VerifyDomainOwnerRequest) (<-chan *VerifyDomainOwnerResponse, <-chan error) {
	responseChan := make(chan *VerifyDomainOwnerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.VerifyDomainOwner(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// VerifyDomainOwnerWithCallback invokes the cdn.VerifyDomainOwner API asynchronously
func (client *Client) VerifyDomainOwnerWithCallback(request *VerifyDomainOwnerRequest, callback func(response *VerifyDomainOwnerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *VerifyDomainOwnerResponse
		var err error
		defer close(result)
		response, err = client.VerifyDomainOwner(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// VerifyDomainOwnerRequest is the request struct for api VerifyDomainOwner
type VerifyDomainOwnerRequest struct {
	*requests.RpcRequest
	GlobalResourcePlan string `position:"Query" name:"GlobalResourcePlan"`
	DomainName         string `position:"Query" name:"DomainName"`
	VerifyType         string `position:"Query" name:"VerifyType"`
}

// VerifyDomainOwnerResponse is the response struct for api VerifyDomainOwner
type VerifyDomainOwnerResponse struct {
	*responses.BaseResponse
	Content   string `json:"Content" xml:"Content"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateVerifyDomainOwnerRequest creates a request to invoke VerifyDomainOwner API
func CreateVerifyDomainOwnerRequest() (request *VerifyDomainOwnerRequest) {
	request = &VerifyDomainOwnerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "VerifyDomainOwner", "", "")
	request.Method = requests.POST
	return
}

// CreateVerifyDomainOwnerResponse creates a response to parse from VerifyDomainOwner response
func CreateVerifyDomainOwnerResponse() (response *VerifyDomainOwnerResponse) {
	response = &VerifyDomainOwnerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
