package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CloseDelivery invokes the cloud_siem.CloseDelivery API synchronously
func (client *Client) CloseDelivery(request *CloseDeliveryRequest) (response *CloseDeliveryResponse, err error) {
	response = CreateCloseDeliveryResponse()
	err = client.DoAction(request, response)
	return
}

// CloseDeliveryWithChan invokes the cloud_siem.CloseDelivery API asynchronously
func (client *Client) CloseDeliveryWithChan(request *CloseDeliveryRequest) (<-chan *CloseDeliveryResponse, <-chan error) {
	responseChan := make(chan *CloseDeliveryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CloseDelivery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CloseDeliveryWithCallback invokes the cloud_siem.CloseDelivery API asynchronously
func (client *Client) CloseDeliveryWithCallback(request *CloseDeliveryRequest, callback func(response *CloseDeliveryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CloseDeliveryResponse
		var err error
		defer close(result)
		response, err = client.CloseDelivery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CloseDeliveryRequest is the request struct for api CloseDelivery
type CloseDeliveryRequest struct {
	*requests.RpcRequest
	ProductCode string `position:"Body" name:"ProductCode"`
	LogCode     string `position:"Body" name:"LogCode"`
}

// CloseDeliveryResponse is the response struct for api CloseDelivery
type CloseDeliveryResponse struct {
	*responses.BaseResponse
	Data      bool   `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCloseDeliveryRequest creates a request to invoke CloseDelivery API
func CreateCloseDeliveryRequest() (request *CloseDeliveryRequest) {
	request = &CloseDeliveryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "CloseDelivery", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCloseDeliveryResponse creates a response to parse from CloseDelivery response
func CreateCloseDeliveryResponse() (response *CloseDeliveryResponse) {
	response = &CloseDeliveryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
