package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLogType invokes the cloud_siem.DescribeLogType API synchronously
func (client *Client) DescribeLogType(request *DescribeLogTypeRequest) (response *DescribeLogTypeResponse, err error) {
	response = CreateDescribeLogTypeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLogTypeWithChan invokes the cloud_siem.DescribeLogType API asynchronously
func (client *Client) DescribeLogTypeWithChan(request *DescribeLogTypeRequest) (<-chan *DescribeLogTypeResponse, <-chan error) {
	responseChan := make(chan *DescribeLogTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLogType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLogTypeWithCallback invokes the cloud_siem.DescribeLogType API asynchronously
func (client *Client) DescribeLogTypeWithCallback(request *DescribeLogTypeRequest, callback func(response *DescribeLogTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLogTypeResponse
		var err error
		defer close(result)
		response, err = client.DescribeLogType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLogTypeRequest is the request struct for api DescribeLogType
type DescribeLogTypeRequest struct {
	*requests.RpcRequest
}

// DescribeLogTypeResponse is the response struct for api DescribeLogType
type DescribeLogTypeResponse struct {
	*responses.BaseResponse
	Success   bool       `json:"Success" xml:"Success"`
	Code      int        `json:"Code" xml:"Code"`
	Message   string     `json:"Message" xml:"Message"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateDescribeLogTypeRequest creates a request to invoke DescribeLogType API
func CreateDescribeLogTypeRequest() (request *DescribeLogTypeRequest) {
	request = &DescribeLogTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "DescribeLogType", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLogTypeResponse creates a response to parse from DescribeLogType response
func CreateDescribeLogTypeResponse() (response *DescribeLogTypeResponse) {
	response = &DescribeLogTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
