package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeServiceStatus invokes the cloud_siem.DescribeServiceStatus API synchronously
func (client *Client) DescribeServiceStatus(request *DescribeServiceStatusRequest) (response *DescribeServiceStatusResponse, err error) {
	response = CreateDescribeServiceStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeServiceStatusWithChan invokes the cloud_siem.DescribeServiceStatus API asynchronously
func (client *Client) DescribeServiceStatusWithChan(request *DescribeServiceStatusRequest) (<-chan *DescribeServiceStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeServiceStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeServiceStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeServiceStatusWithCallback invokes the cloud_siem.DescribeServiceStatus API asynchronously
func (client *Client) DescribeServiceStatusWithCallback(request *DescribeServiceStatusRequest, callback func(response *DescribeServiceStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeServiceStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeServiceStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeServiceStatusRequest is the request struct for api DescribeServiceStatus
type DescribeServiceStatusRequest struct {
	*requests.RpcRequest
}

// DescribeServiceStatusResponse is the response struct for api DescribeServiceStatus
type DescribeServiceStatusResponse struct {
	*responses.BaseResponse
	Data      bool   `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDescribeServiceStatusRequest creates a request to invoke DescribeServiceStatus API
func CreateDescribeServiceStatusRequest() (request *DescribeServiceStatusRequest) {
	request = &DescribeServiceStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "DescribeServiceStatus", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeServiceStatusResponse creates a response to parse from DescribeServiceStatus response
func CreateDescribeServiceStatusResponse() (response *DescribeServiceStatusResponse) {
	response = &DescribeServiceStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
