package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDatasetItemInfo invokes the cloudapi.DescribeDatasetItemInfo API synchronously
func (client *Client) DescribeDatasetItemInfo(request *DescribeDatasetItemInfoRequest) (response *DescribeDatasetItemInfoResponse, err error) {
	response = CreateDescribeDatasetItemInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDatasetItemInfoWithChan invokes the cloudapi.DescribeDatasetItemInfo API asynchronously
func (client *Client) DescribeDatasetItemInfoWithChan(request *DescribeDatasetItemInfoRequest) (<-chan *DescribeDatasetItemInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeDatasetItemInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDatasetItemInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDatasetItemInfoWithCallback invokes the cloudapi.DescribeDatasetItemInfo API asynchronously
func (client *Client) DescribeDatasetItemInfoWithCallback(request *DescribeDatasetItemInfoRequest, callback func(response *DescribeDatasetItemInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDatasetItemInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeDatasetItemInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDatasetItemInfoRequest is the request struct for api DescribeDatasetItemInfo
type DescribeDatasetItemInfoRequest struct {
	*requests.RpcRequest
	SecurityToken string `position:"Query" name:"SecurityToken"`
	DatasetId     string `position:"Query" name:"DatasetId"`
	Value         string `position:"Query" name:"Value"`
	DatasetItemId string `position:"Query" name:"DatasetItemId"`
}

// DescribeDatasetItemInfoResponse is the response struct for api DescribeDatasetItemInfo
type DescribeDatasetItemInfoResponse struct {
	*responses.BaseResponse
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	DatasetItemInfo DatasetItemInfo `json:"DatasetItemInfo" xml:"DatasetItemInfo"`
}

// CreateDescribeDatasetItemInfoRequest creates a request to invoke DescribeDatasetItemInfo API
func CreateDescribeDatasetItemInfoRequest() (request *DescribeDatasetItemInfoRequest) {
	request = &DescribeDatasetItemInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "DescribeDatasetItemInfo", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDatasetItemInfoResponse creates a response to parse from DescribeDatasetItemInfo response
func CreateDescribeDatasetItemInfoResponse() (response *DescribeDatasetItemInfoResponse) {
	response = &DescribeDatasetItemInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
