package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ImportOAS invokes the cloudapi.ImportOAS API synchronously
func (client *Client) ImportOAS(request *ImportOASRequest) (response *ImportOASResponse, err error) {
	response = CreateImportOASResponse()
	err = client.DoAction(request, response)
	return
}

// ImportOASWithChan invokes the cloudapi.ImportOAS API asynchronously
func (client *Client) ImportOASWithChan(request *ImportOASRequest) (<-chan *ImportOASResponse, <-chan error) {
	responseChan := make(chan *ImportOASResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ImportOAS(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ImportOASWithCallback invokes the cloudapi.ImportOAS API asynchronously
func (client *Client) ImportOASWithCallback(request *ImportOASRequest, callback func(response *ImportOASResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ImportOASResponse
		var err error
		defer close(result)
		response, err = client.ImportOAS(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ImportOASRequest is the request struct for api ImportOAS
type ImportOASRequest struct {
	*requests.RpcRequest
	Data          string           `position:"Body" name:"Data"`
	AuthType      string           `position:"Query" name:"AuthType"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	Overwrite     requests.Boolean `position:"Query" name:"Overwrite"`
	DryRun        requests.Boolean `position:"Query" name:"DryRun"`
	IgnoreWarning requests.Boolean `position:"Query" name:"IgnoreWarning"`
	GroupId       string           `position:"Query" name:"GroupId"`
	RequestMode   string           `position:"Query" name:"RequestMode"`
	BackendName   string           `position:"Query" name:"BackendName"`
	SkipDryRun    requests.Boolean `position:"Query" name:"SkipDryRun"`
	OASVersion    string           `position:"Query" name:"OASVersion"`
}

// ImportOASResponse is the response struct for api ImportOAS
type ImportOASResponse struct {
	*responses.BaseResponse
	OperationId     string          `json:"OperationId" xml:"OperationId"`
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	ErrorMessages   ErrorMessages   `json:"ErrorMessages" xml:"ErrorMessages"`
	WarningMessages WarningMessages `json:"WarningMessages" xml:"WarningMessages"`
	SuccessApis     SuccessApis     `json:"SuccessApis" xml:"SuccessApis"`
	FailedApis      FailedApis      `json:"FailedApis" xml:"FailedApis"`
	FailedModels    FailedModels    `json:"FailedModels" xml:"FailedModels"`
	SuccessModels   SuccessModels   `json:"SuccessModels" xml:"SuccessModels"`
}

// CreateImportOASRequest creates a request to invoke ImportOAS API
func CreateImportOASRequest() (request *ImportOASRequest) {
	request = &ImportOASRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "ImportOAS", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateImportOASResponse creates a response to parse from ImportOAS response
func CreateImportOASResponse() (response *ImportOASResponse) {
	response = &ImportOASResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
