package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeepfakeDetect invokes the cloudauth.DeepfakeDetect API synchronously
func (client *Client) DeepfakeDetect(request *DeepfakeDetectRequest) (response *DeepfakeDetectResponse, err error) {
	response = CreateDeepfakeDetectResponse()
	err = client.DoAction(request, response)
	return
}

// DeepfakeDetectWithChan invokes the cloudauth.DeepfakeDetect API asynchronously
func (client *Client) DeepfakeDetectWithChan(request *DeepfakeDetectRequest) (<-chan *DeepfakeDetectResponse, <-chan error) {
	responseChan := make(chan *DeepfakeDetectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeepfakeDetect(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeepfakeDetectWithCallback invokes the cloudauth.DeepfakeDetect API asynchronously
func (client *Client) DeepfakeDetectWithCallback(request *DeepfakeDetectRequest, callback func(response *DeepfakeDetectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeepfakeDetectResponse
		var err error
		defer close(result)
		response, err = client.DeepfakeDetect(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeepfakeDetectRequest is the request struct for api DeepfakeDetect
type DeepfakeDetectRequest struct {
	*requests.RpcRequest
	FaceBase64    string `position:"Body" name:"FaceBase64"`
	OuterOrderNo  string `position:"Query" name:"OuterOrderNo"`
	FaceUrl       string `position:"Query" name:"FaceUrl"`
	FaceInputType string `position:"Query" name:"FaceInputType"`
}

// DeepfakeDetectResponse is the response struct for api DeepfakeDetect
type DeepfakeDetectResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	Code         string       `json:"Code" xml:"Code"`
	Message      string       `json:"Message" xml:"Message"`
	ResultObject ResultObject `json:"ResultObject" xml:"ResultObject"`
}

// CreateDeepfakeDetectRequest creates a request to invoke DeepfakeDetect API
func CreateDeepfakeDetectRequest() (request *DeepfakeDetectRequest) {
	request = &DeepfakeDetectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2019-03-07", "DeepfakeDetect", "cloudauth", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeepfakeDetectResponse creates a response to parse from DeepfakeDetect response
func CreateDeepfakeDetectResponse() (response *DeepfakeDetectResponse) {
	response = &DeepfakeDetectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
