package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// Id2MetaPeriodVerify invokes the cloudauth.Id2MetaPeriodVerify API synchronously
func (client *Client) Id2MetaPeriodVerify(request *Id2MetaPeriodVerifyRequest) (response *Id2MetaPeriodVerifyResponse, err error) {
	response = CreateId2MetaPeriodVerifyResponse()
	err = client.DoAction(request, response)
	return
}

// Id2MetaPeriodVerifyWithChan invokes the cloudauth.Id2MetaPeriodVerify API asynchronously
func (client *Client) Id2MetaPeriodVerifyWithChan(request *Id2MetaPeriodVerifyRequest) (<-chan *Id2MetaPeriodVerifyResponse, <-chan error) {
	responseChan := make(chan *Id2MetaPeriodVerifyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.Id2MetaPeriodVerify(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// Id2MetaPeriodVerifyWithCallback invokes the cloudauth.Id2MetaPeriodVerify API asynchronously
func (client *Client) Id2MetaPeriodVerifyWithCallback(request *Id2MetaPeriodVerifyRequest, callback func(response *Id2MetaPeriodVerifyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *Id2MetaPeriodVerifyResponse
		var err error
		defer close(result)
		response, err = client.Id2MetaPeriodVerify(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// Id2MetaPeriodVerifyRequest is the request struct for api Id2MetaPeriodVerify
type Id2MetaPeriodVerifyRequest struct {
	*requests.RpcRequest
	ParamType         string `position:"Body" name:"ParamType"`
	ValidityStartDate string `position:"Body" name:"ValidityStartDate"`
	ValidityEndDate   string `position:"Body" name:"ValidityEndDate"`
	IdentifyNum       string `position:"Body" name:"IdentifyNum"`
	UserName          string `position:"Body" name:"UserName"`
}

// Id2MetaPeriodVerifyResponse is the response struct for api Id2MetaPeriodVerify
type Id2MetaPeriodVerifyResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	Code         string       `json:"Code" xml:"Code"`
	Message      string       `json:"Message" xml:"Message"`
	ResultObject ResultObject `json:"ResultObject" xml:"ResultObject"`
}

// CreateId2MetaPeriodVerifyRequest creates a request to invoke Id2MetaPeriodVerify API
func CreateId2MetaPeriodVerifyRequest() (request *Id2MetaPeriodVerifyRequest) {
	request = &Id2MetaPeriodVerifyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2019-03-07", "Id2MetaPeriodVerify", "cloudauth", "openAPI")
	request.Method = requests.POST
	return
}

// CreateId2MetaPeriodVerifyResponse creates a response to parse from Id2MetaPeriodVerify response
func CreateId2MetaPeriodVerifyResponse() (response *Id2MetaPeriodVerifyResponse) {
	response = &Id2MetaPeriodVerifyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
