package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVpcFirewallAclGroupList invokes the cloudfw.DescribeVpcFirewallAclGroupList API synchronously
func (client *Client) DescribeVpcFirewallAclGroupList(request *DescribeVpcFirewallAclGroupListRequest) (response *DescribeVpcFirewallAclGroupListResponse, err error) {
	response = CreateDescribeVpcFirewallAclGroupListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVpcFirewallAclGroupListWithChan invokes the cloudfw.DescribeVpcFirewallAclGroupList API asynchronously
func (client *Client) DescribeVpcFirewallAclGroupListWithChan(request *DescribeVpcFirewallAclGroupListRequest) (<-chan *DescribeVpcFirewallAclGroupListResponse, <-chan error) {
	responseChan := make(chan *DescribeVpcFirewallAclGroupListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVpcFirewallAclGroupList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVpcFirewallAclGroupListWithCallback invokes the cloudfw.DescribeVpcFirewallAclGroupList API asynchronously
func (client *Client) DescribeVpcFirewallAclGroupListWithCallback(request *DescribeVpcFirewallAclGroupListRequest, callback func(response *DescribeVpcFirewallAclGroupListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVpcFirewallAclGroupListResponse
		var err error
		defer close(result)
		response, err = client.DescribeVpcFirewallAclGroupList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVpcFirewallAclGroupListRequest is the request struct for api DescribeVpcFirewallAclGroupList
type DescribeVpcFirewallAclGroupListRequest struct {
	*requests.RpcRequest
	CurrentPage             string `position:"Query" name:"CurrentPage"`
	SourceIp                string `position:"Query" name:"SourceIp"`
	PageSize                string `position:"Query" name:"PageSize"`
	FirewallConfigureStatus string `position:"Query" name:"FirewallConfigureStatus"`
	Lang                    string `position:"Query" name:"Lang"`
}

// DescribeVpcFirewallAclGroupListResponse is the response struct for api DescribeVpcFirewallAclGroupList
type DescribeVpcFirewallAclGroupListResponse struct {
	*responses.BaseResponse
	TotalCount   int                                     `json:"TotalCount" xml:"TotalCount"`
	RequestId    string                                  `json:"RequestId" xml:"RequestId"`
	AclGroupList []DataInDescribeVpcFirewallAclGroupList `json:"AclGroupList" xml:"AclGroupList"`
}

// CreateDescribeVpcFirewallAclGroupListRequest creates a request to invoke DescribeVpcFirewallAclGroupList API
func CreateDescribeVpcFirewallAclGroupListRequest() (request *DescribeVpcFirewallAclGroupListRequest) {
	request = &DescribeVpcFirewallAclGroupListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "DescribeVpcFirewallAclGroupList", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeVpcFirewallAclGroupListResponse creates a response to parse from DescribeVpcFirewallAclGroupList response
func CreateDescribeVpcFirewallAclGroupListResponse() (response *DescribeVpcFirewallAclGroupListResponse) {
	response = &DescribeVpcFirewallAclGroupListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
