package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchExport invokes the cms.BatchExport API synchronously
func (client *Client) BatchExport(request *BatchExportRequest) (response *BatchExportResponse, err error) {
	response = CreateBatchExportResponse()
	err = client.DoAction(request, response)
	return
}

// BatchExportWithChan invokes the cms.BatchExport API asynchronously
func (client *Client) BatchExportWithChan(request *BatchExportRequest) (<-chan *BatchExportResponse, <-chan error) {
	responseChan := make(chan *BatchExportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchExport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchExportWithCallback invokes the cms.BatchExport API asynchronously
func (client *Client) BatchExportWithCallback(request *BatchExportRequest, callback func(response *BatchExportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchExportResponse
		var err error
		defer close(result)
		response, err = client.BatchExport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchExportRequest is the request struct for api BatchExport
type BatchExportRequest struct {
	*requests.RpcRequest
	Cursor       string           `position:"Body" name:"Cursor"`
	Length       requests.Integer `position:"Body" name:"Length"`
	Metric       string           `position:"Body" name:"Metric"`
	Namespace    string           `position:"Body" name:"Namespace"`
	Measurements *[]string        `position:"Body" name:"Measurements"  type:"Json"`
}

// BatchExportResponse is the response struct for api BatchExport
type BatchExportResponse struct {
	*responses.BaseResponse
	Message     string       `json:"Message" xml:"Message"`
	Code        int          `json:"Code" xml:"Code"`
	Success     bool         `json:"Success" xml:"Success"`
	RequestId   string       `json:"RequestId" xml:"RequestId"`
	Cursor      string       `json:"Cursor" xml:"Cursor"`
	Length      int          `json:"Length" xml:"Length"`
	Anchor      int64        `json:"Anchor" xml:"Anchor"`
	HasNext     bool         `json:"HasNext" xml:"HasNext"`
	DataResults []DataResult `json:"DataResults" xml:"DataResults"`
}

// CreateBatchExportRequest creates a request to invoke BatchExport API
func CreateBatchExportRequest() (request *BatchExportRequest) {
	request = &BatchExportRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "BatchExport", "cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBatchExportResponse creates a response to parse from BatchExport response
func CreateBatchExportResponse() (response *BatchExportResponse) {
	response = &BatchExportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
