package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryCommodityConfig invokes the companyreg.QueryCommodityConfig API synchronously
func (client *Client) QueryCommodityConfig(request *QueryCommodityConfigRequest) (response *QueryCommodityConfigResponse, err error) {
	response = CreateQueryCommodityConfigResponse()
	err = client.DoAction(request, response)
	return
}

// QueryCommodityConfigWithChan invokes the companyreg.QueryCommodityConfig API asynchronously
func (client *Client) QueryCommodityConfigWithChan(request *QueryCommodityConfigRequest) (<-chan *QueryCommodityConfigResponse, <-chan error) {
	responseChan := make(chan *QueryCommodityConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryCommodityConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryCommodityConfigWithCallback invokes the companyreg.QueryCommodityConfig API asynchronously
func (client *Client) QueryCommodityConfigWithCallback(request *QueryCommodityConfigRequest, callback func(response *QueryCommodityConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryCommodityConfigResponse
		var err error
		defer close(result)
		response, err = client.QueryCommodityConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryCommodityConfigRequest is the request struct for api QueryCommodityConfig
type QueryCommodityConfigRequest struct {
	*requests.RpcRequest
	BizType       string           `position:"Query" name:"BizType"`
	QueryModule   requests.Boolean `position:"Query" name:"QueryModule"`
	CommodityCode string           `position:"Query" name:"CommodityCode"`
}

// QueryCommodityConfigResponse is the response struct for api QueryCommodityConfig
type QueryCommodityConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateQueryCommodityConfigRequest creates a request to invoke QueryCommodityConfig API
func CreateQueryCommodityConfigRequest() (request *QueryCommodityConfigRequest) {
	request = &QueryCommodityConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-03-06", "QueryCommodityConfig", "companyreg", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryCommodityConfigResponse creates a response to parse from QueryCommodityConfig response
func CreateQueryCommodityConfigResponse() (response *QueryCommodityConfigResponse) {
	response = &QueryCommodityConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
