package computenestsupplier

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateServiceInstanceSpec invokes the computenestsupplier.UpdateServiceInstanceSpec API synchronously
func (client *Client) UpdateServiceInstanceSpec(request *UpdateServiceInstanceSpecRequest) (response *UpdateServiceInstanceSpecResponse, err error) {
	response = CreateUpdateServiceInstanceSpecResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateServiceInstanceSpecWithChan invokes the computenestsupplier.UpdateServiceInstanceSpec API asynchronously
func (client *Client) UpdateServiceInstanceSpecWithChan(request *UpdateServiceInstanceSpecRequest) (<-chan *UpdateServiceInstanceSpecResponse, <-chan error) {
	responseChan := make(chan *UpdateServiceInstanceSpecResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateServiceInstanceSpec(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateServiceInstanceSpecWithCallback invokes the computenestsupplier.UpdateServiceInstanceSpec API asynchronously
func (client *Client) UpdateServiceInstanceSpecWithCallback(request *UpdateServiceInstanceSpecRequest, callback func(response *UpdateServiceInstanceSpecResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateServiceInstanceSpecResponse
		var err error
		defer close(result)
		response, err = client.UpdateServiceInstanceSpec(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateServiceInstanceSpecRequest is the request struct for api UpdateServiceInstanceSpec
type UpdateServiceInstanceSpecRequest struct {
	*requests.RpcRequest
	ClientToken              string           `position:"Query" name:"ClientToken"`
	PredefinedParametersName string           `position:"Query" name:"PredefinedParametersName"`
	ServiceInstanceId        string           `position:"Query" name:"ServiceInstanceId"`
	EnableUserPrometheus     requests.Boolean `position:"Query" name:"EnableUserPrometheus"`
	OperationName            string           `position:"Query" name:"OperationName"`
	Parameters               string           `position:"Query" name:"Parameters"`
}

// UpdateServiceInstanceSpecResponse is the response struct for api UpdateServiceInstanceSpec
type UpdateServiceInstanceSpecResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	OrderId   string `json:"OrderId" xml:"OrderId"`
}

// CreateUpdateServiceInstanceSpecRequest creates a request to invoke UpdateServiceInstanceSpec API
func CreateUpdateServiceInstanceSpecRequest() (request *UpdateServiceInstanceSpecRequest) {
	request = &UpdateServiceInstanceSpecRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ComputeNestSupplier", "2021-05-21", "UpdateServiceInstanceSpec", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateServiceInstanceSpecResponse creates a response to parse from UpdateServiceInstanceSpec response
func CreateUpdateServiceInstanceSpecResponse() (response *UpdateServiceInstanceSpecResponse) {
	response = &UpdateServiceInstanceSpecResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
