package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenerateResourceInventory invokes the config.GenerateResourceInventory API synchronously
func (client *Client) GenerateResourceInventory(request *GenerateResourceInventoryRequest) (response *GenerateResourceInventoryResponse, err error) {
	response = CreateGenerateResourceInventoryResponse()
	err = client.DoAction(request, response)
	return
}

// GenerateResourceInventoryWithChan invokes the config.GenerateResourceInventory API asynchronously
func (client *Client) GenerateResourceInventoryWithChan(request *GenerateResourceInventoryRequest) (<-chan *GenerateResourceInventoryResponse, <-chan error) {
	responseChan := make(chan *GenerateResourceInventoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenerateResourceInventory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenerateResourceInventoryWithCallback invokes the config.GenerateResourceInventory API asynchronously
func (client *Client) GenerateResourceInventoryWithCallback(request *GenerateResourceInventoryRequest, callback func(response *GenerateResourceInventoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenerateResourceInventoryResponse
		var err error
		defer close(result)
		response, err = client.GenerateResourceInventory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenerateResourceInventoryRequest is the request struct for api GenerateResourceInventory
type GenerateResourceInventoryRequest struct {
	*requests.RpcRequest
	Regions       string `position:"Query" name:"Regions"`
	ResourceTypes string `position:"Query" name:"ResourceTypes"`
}

// GenerateResourceInventoryResponse is the response struct for api GenerateResourceInventory
type GenerateResourceInventoryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateGenerateResourceInventoryRequest creates a request to invoke GenerateResourceInventory API
func CreateGenerateResourceInventoryRequest() (request *GenerateResourceInventoryRequest) {
	request = &GenerateResourceInventoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "GenerateResourceInventory", "", "")
	request.Method = requests.POST
	return
}

// CreateGenerateResourceInventoryResponse creates a response to parse from GenerateResourceInventory response
func CreateGenerateResourceInventoryResponse() (response *GenerateResourceInventoryResponse) {
	response = &GenerateResourceInventoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
