package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteApprovalProcesses invokes the csas.DeleteApprovalProcesses API synchronously
func (client *Client) DeleteApprovalProcesses(request *DeleteApprovalProcessesRequest) (response *DeleteApprovalProcessesResponse, err error) {
	response = CreateDeleteApprovalProcessesResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteApprovalProcessesWithChan invokes the csas.DeleteApprovalProcesses API asynchronously
func (client *Client) DeleteApprovalProcessesWithChan(request *DeleteApprovalProcessesRequest) (<-chan *DeleteApprovalProcessesResponse, <-chan error) {
	responseChan := make(chan *DeleteApprovalProcessesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteApprovalProcesses(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteApprovalProcessesWithCallback invokes the csas.DeleteApprovalProcesses API asynchronously
func (client *Client) DeleteApprovalProcessesWithCallback(request *DeleteApprovalProcessesRequest, callback func(response *DeleteApprovalProcessesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteApprovalProcessesResponse
		var err error
		defer close(result)
		response, err = client.DeleteApprovalProcesses(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteApprovalProcessesRequest is the request struct for api DeleteApprovalProcesses
type DeleteApprovalProcessesRequest struct {
	*requests.RpcRequest
	ProcessIds *[]string `position:"Body" name:"ProcessIds"  type:"Repeated"`
	SourceIp   string    `position:"Query" name:"SourceIp"`
}

// DeleteApprovalProcessesResponse is the response struct for api DeleteApprovalProcesses
type DeleteApprovalProcessesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteApprovalProcessesRequest creates a request to invoke DeleteApprovalProcesses API
func CreateDeleteApprovalProcessesRequest() (request *DeleteApprovalProcessesRequest) {
	request = &DeleteApprovalProcessesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "DeleteApprovalProcesses", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteApprovalProcessesResponse creates a response to parse from DeleteApprovalProcesses response
func CreateDeleteApprovalProcessesResponse() (response *DeleteApprovalProcessesResponse) {
	response = &DeleteApprovalProcessesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
