package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteUserGroup invokes the csas.DeleteUserGroup API synchronously
func (client *Client) DeleteUserGroup(request *DeleteUserGroupRequest) (response *DeleteUserGroupResponse, err error) {
	response = CreateDeleteUserGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteUserGroupWithChan invokes the csas.DeleteUserGroup API asynchronously
func (client *Client) DeleteUserGroupWithChan(request *DeleteUserGroupRequest) (<-chan *DeleteUserGroupResponse, <-chan error) {
	responseChan := make(chan *DeleteUserGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteUserGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteUserGroupWithCallback invokes the csas.DeleteUserGroup API asynchronously
func (client *Client) DeleteUserGroupWithCallback(request *DeleteUserGroupRequest, callback func(response *DeleteUserGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteUserGroupResponse
		var err error
		defer close(result)
		response, err = client.DeleteUserGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteUserGroupRequest is the request struct for api DeleteUserGroup
type DeleteUserGroupRequest struct {
	*requests.RpcRequest
	UserGroupId string `position:"Body" name:"UserGroupId"`
	SourceIp    string `position:"Query" name:"SourceIp"`
}

// DeleteUserGroupResponse is the response struct for api DeleteUserGroup
type DeleteUserGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteUserGroupRequest creates a request to invoke DeleteUserGroup API
func CreateDeleteUserGroupRequest() (request *DeleteUserGroupRequest) {
	request = &DeleteUserGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "DeleteUserGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteUserGroupResponse creates a response to parse from DeleteUserGroup response
func CreateDeleteUserGroupResponse() (response *DeleteUserGroupResponse) {
	response = &DeleteUserGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
