package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListApprovalSchemasForApprovalProcesses invokes the csas.ListApprovalSchemasForApprovalProcesses API synchronously
func (client *Client) ListApprovalSchemasForApprovalProcesses(request *ListApprovalSchemasForApprovalProcessesRequest) (response *ListApprovalSchemasForApprovalProcessesResponse, err error) {
	response = CreateListApprovalSchemasForApprovalProcessesResponse()
	err = client.DoAction(request, response)
	return
}

// ListApprovalSchemasForApprovalProcessesWithChan invokes the csas.ListApprovalSchemasForApprovalProcesses API asynchronously
func (client *Client) ListApprovalSchemasForApprovalProcessesWithChan(request *ListApprovalSchemasForApprovalProcessesRequest) (<-chan *ListApprovalSchemasForApprovalProcessesResponse, <-chan error) {
	responseChan := make(chan *ListApprovalSchemasForApprovalProcessesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListApprovalSchemasForApprovalProcesses(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListApprovalSchemasForApprovalProcessesWithCallback invokes the csas.ListApprovalSchemasForApprovalProcesses API asynchronously
func (client *Client) ListApprovalSchemasForApprovalProcessesWithCallback(request *ListApprovalSchemasForApprovalProcessesRequest, callback func(response *ListApprovalSchemasForApprovalProcessesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListApprovalSchemasForApprovalProcessesResponse
		var err error
		defer close(result)
		response, err = client.ListApprovalSchemasForApprovalProcesses(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListApprovalSchemasForApprovalProcessesRequest is the request struct for api ListApprovalSchemasForApprovalProcesses
type ListApprovalSchemasForApprovalProcessesRequest struct {
	*requests.RpcRequest
	ProcessIds *[]string `position:"Query" name:"ProcessIds"  type:"Repeated"`
	SourceIp   string    `position:"Query" name:"SourceIp"`
}

// ListApprovalSchemasForApprovalProcessesResponse is the response struct for api ListApprovalSchemasForApprovalProcesses
type ListApprovalSchemasForApprovalProcessesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Processes []Data `json:"Processes" xml:"Processes"`
}

// CreateListApprovalSchemasForApprovalProcessesRequest creates a request to invoke ListApprovalSchemasForApprovalProcesses API
func CreateListApprovalSchemasForApprovalProcessesRequest() (request *ListApprovalSchemasForApprovalProcessesRequest) {
	request = &ListApprovalSchemasForApprovalProcessesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "ListApprovalSchemasForApprovalProcesses", "", "")
	request.Method = requests.GET
	return
}

// CreateListApprovalSchemasForApprovalProcessesResponse creates a response to parse from ListApprovalSchemasForApprovalProcesses response
func CreateListApprovalSchemasForApprovalProcessesResponse() (response *ListApprovalSchemasForApprovalProcessesResponse) {
	response = &ListApprovalSchemasForApprovalProcessesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
