package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPfsSqlSample invokes the das.GetPfsSqlSample API synchronously
func (client *Client) GetPfsSqlSample(request *GetPfsSqlSampleRequest) (response *GetPfsSqlSampleResponse, err error) {
	response = CreateGetPfsSqlSampleResponse()
	err = client.DoAction(request, response)
	return
}

// GetPfsSqlSampleWithChan invokes the das.GetPfsSqlSample API asynchronously
func (client *Client) GetPfsSqlSampleWithChan(request *GetPfsSqlSampleRequest) (<-chan *GetPfsSqlSampleResponse, <-chan error) {
	responseChan := make(chan *GetPfsSqlSampleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPfsSqlSample(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPfsSqlSampleWithCallback invokes the das.GetPfsSqlSample API asynchronously
func (client *Client) GetPfsSqlSampleWithCallback(request *GetPfsSqlSampleRequest, callback func(response *GetPfsSqlSampleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPfsSqlSampleResponse
		var err error
		defer close(result)
		response, err = client.GetPfsSqlSample(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPfsSqlSampleRequest is the request struct for api GetPfsSqlSample
type GetPfsSqlSampleRequest struct {
	*requests.RpcRequest
	ConsoleContext string           `position:"Query" name:"ConsoleContext"`
	InstanceId     string           `position:"Body" name:"InstanceId"`
	NodeId         string           `position:"Body" name:"NodeId"`
	SqlId          string           `position:"Body" name:"SqlId"`
	StartTime      requests.Integer `position:"Body" name:"StartTime"`
	EndTime        requests.Integer `position:"Body" name:"EndTime"`
}

// GetPfsSqlSampleResponse is the response struct for api GetPfsSqlSample
type GetPfsSqlSampleResponse struct {
	*responses.BaseResponse
	Message   string   `json:"Message" xml:"Message"`
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Code      int64    `json:"Code" xml:"Code"`
	Success   bool     `json:"Success" xml:"Success"`
	Data      []Sample `json:"Data" xml:"Data"`
}

// CreateGetPfsSqlSampleRequest creates a request to invoke GetPfsSqlSample API
func CreateGetPfsSqlSampleRequest() (request *GetPfsSqlSampleRequest) {
	request = &GetPfsSqlSampleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "GetPfsSqlSample", "", "")
	request.Method = requests.POST
	return
}

// CreateGetPfsSqlSampleResponse creates a response to parse from GetPfsSqlSample response
func CreateGetPfsSqlSampleResponse() (response *GetPfsSqlSampleResponse) {
	response = &GetPfsSqlSampleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
