package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListNodeInputOrOutput invokes the dataworks_public.ListNodeInputOrOutput API synchronously
func (client *Client) ListNodeInputOrOutput(request *ListNodeInputOrOutputRequest) (response *ListNodeInputOrOutputResponse, err error) {
	response = CreateListNodeInputOrOutputResponse()
	err = client.DoAction(request, response)
	return
}

// ListNodeInputOrOutputWithChan invokes the dataworks_public.ListNodeInputOrOutput API asynchronously
func (client *Client) ListNodeInputOrOutputWithChan(request *ListNodeInputOrOutputRequest) (<-chan *ListNodeInputOrOutputResponse, <-chan error) {
	responseChan := make(chan *ListNodeInputOrOutputResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListNodeInputOrOutput(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListNodeInputOrOutputWithCallback invokes the dataworks_public.ListNodeInputOrOutput API asynchronously
func (client *Client) ListNodeInputOrOutputWithCallback(request *ListNodeInputOrOutputRequest, callback func(response *ListNodeInputOrOutputResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListNodeInputOrOutputResponse
		var err error
		defer close(result)
		response, err = client.ListNodeInputOrOutput(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListNodeInputOrOutputRequest is the request struct for api ListNodeInputOrOutput
type ListNodeInputOrOutputRequest struct {
	*requests.RpcRequest
	ProjectEnv string           `position:"Body" name:"ProjectEnv"`
	NodeId     requests.Integer `position:"Body" name:"NodeId"`
	IoType     string           `position:"Body" name:"IoType"`
}

// ListNodeInputOrOutputResponse is the response struct for api ListNodeInputOrOutput
type ListNodeInputOrOutputResponse struct {
	*responses.BaseResponse
	HttpStatusCode int        `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string     `json:"RequestId" xml:"RequestId"`
	ErrorMessage   string     `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode      string     `json:"ErrorCode" xml:"ErrorCode"`
	Success        bool       `json:"Success" xml:"Success"`
	Data           []DataItem `json:"Data" xml:"Data"`
}

// CreateListNodeInputOrOutputRequest creates a request to invoke ListNodeInputOrOutput API
func CreateListNodeInputOrOutputRequest() (request *ListNodeInputOrOutputRequest) {
	request = &ListNodeInputOrOutputRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ListNodeInputOrOutput", "", "")
	request.Method = requests.POST
	return
}

// CreateListNodeInputOrOutputResponse creates a response to parse from ListNodeInputOrOutput response
func CreateListNodeInputOrOutputResponse() (response *ListNodeInputOrOutputResponse) {
	response = &ListNodeInputOrOutputResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
