package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartDISyncInstance invokes the dataworks_public.StartDISyncInstance API synchronously
func (client *Client) StartDISyncInstance(request *StartDISyncInstanceRequest) (response *StartDISyncInstanceResponse, err error) {
	response = CreateStartDISyncInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// StartDISyncInstanceWithChan invokes the dataworks_public.StartDISyncInstance API asynchronously
func (client *Client) StartDISyncInstanceWithChan(request *StartDISyncInstanceRequest) (<-chan *StartDISyncInstanceResponse, <-chan error) {
	responseChan := make(chan *StartDISyncInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartDISyncInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartDISyncInstanceWithCallback invokes the dataworks_public.StartDISyncInstance API asynchronously
func (client *Client) StartDISyncInstanceWithCallback(request *StartDISyncInstanceRequest, callback func(response *StartDISyncInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartDISyncInstanceResponse
		var err error
		defer close(result)
		response, err = client.StartDISyncInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartDISyncInstanceRequest is the request struct for api StartDISyncInstance
type StartDISyncInstanceRequest struct {
	*requests.RpcRequest
	TaskType   string           `position:"Query" name:"TaskType"`
	StartParam string           `position:"Query" name:"StartParam"`
	ProjectId  requests.Integer `position:"Query" name:"ProjectId"`
	FileId     requests.Integer `position:"Query" name:"FileId"`
}

// StartDISyncInstanceResponse is the response struct for api StartDISyncInstance
type StartDISyncInstanceResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateStartDISyncInstanceRequest creates a request to invoke StartDISyncInstance API
func CreateStartDISyncInstanceRequest() (request *StartDISyncInstanceRequest) {
	request = &StartDISyncInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "StartDISyncInstance", "", "")
	request.Method = requests.POST
	return
}

// CreateStartDISyncInstanceResponse creates a response to parse from StartDISyncInstance response
func CreateStartDISyncInstanceResponse() (response *StartDISyncInstanceResponse) {
	response = &StartDISyncInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
