package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDcdnKv invokes the dcdn.DeleteDcdnKv API synchronously
func (client *Client) DeleteDcdnKv(request *DeleteDcdnKvRequest) (response *DeleteDcdnKvResponse, err error) {
	response = CreateDeleteDcdnKvResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDcdnKvWithChan invokes the dcdn.DeleteDcdnKv API asynchronously
func (client *Client) DeleteDcdnKvWithChan(request *DeleteDcdnKvRequest) (<-chan *DeleteDcdnKvResponse, <-chan error) {
	responseChan := make(chan *DeleteDcdnKvResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDcdnKv(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDcdnKvWithCallback invokes the dcdn.DeleteDcdnKv API asynchronously
func (client *Client) DeleteDcdnKvWithCallback(request *DeleteDcdnKvRequest, callback func(response *DeleteDcdnKvResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDcdnKvResponse
		var err error
		defer close(result)
		response, err = client.DeleteDcdnKv(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDcdnKvRequest is the request struct for api DeleteDcdnKv
type DeleteDcdnKvRequest struct {
	*requests.RpcRequest
	Namespace string `position:"Query" name:"Namespace"`
	Key       string `position:"Query" name:"Key"`
}

// DeleteDcdnKvResponse is the response struct for api DeleteDcdnKv
type DeleteDcdnKvResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDcdnKvRequest creates a request to invoke DeleteDcdnKv API
func CreateDeleteDcdnKvRequest() (request *DeleteDcdnKvRequest) {
	request = &DeleteDcdnKvRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DeleteDcdnKv", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteDcdnKvResponse creates a response to parse from DeleteDcdnKv response
func CreateDeleteDcdnKvResponse() (response *DeleteDcdnKvResponse) {
	response = &DeleteDcdnKvResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
