package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnKvNamespace invokes the dcdn.DescribeDcdnKvNamespace API synchronously
func (client *Client) DescribeDcdnKvNamespace(request *DescribeDcdnKvNamespaceRequest) (response *DescribeDcdnKvNamespaceResponse, err error) {
	response = CreateDescribeDcdnKvNamespaceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnKvNamespaceWithChan invokes the dcdn.DescribeDcdnKvNamespace API asynchronously
func (client *Client) DescribeDcdnKvNamespaceWithChan(request *DescribeDcdnKvNamespaceRequest) (<-chan *DescribeDcdnKvNamespaceResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnKvNamespaceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnKvNamespace(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnKvNamespaceWithCallback invokes the dcdn.DescribeDcdnKvNamespace API asynchronously
func (client *Client) DescribeDcdnKvNamespaceWithCallback(request *DescribeDcdnKvNamespaceRequest, callback func(response *DescribeDcdnKvNamespaceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnKvNamespaceResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnKvNamespace(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnKvNamespaceRequest is the request struct for api DescribeDcdnKvNamespace
type DescribeDcdnKvNamespaceRequest struct {
	*requests.RpcRequest
	Namespace string `position:"Query" name:"Namespace"`
}

// DescribeDcdnKvNamespaceResponse is the response struct for api DescribeDcdnKvNamespace
type DescribeDcdnKvNamespaceResponse struct {
	*responses.BaseResponse
	Status             string `json:"Status" xml:"Status"`
	Namespace          string `json:"Namespace" xml:"Namespace"`
	NamespaceId        string `json:"NamespaceId" xml:"NamespaceId"`
	RequestId          string `json:"RequestId" xml:"RequestId"`
	Description        string `json:"Description" xml:"Description"`
	CapacityString     string `json:"CapacityString" xml:"CapacityString"`
	CapacityUsedString string `json:"CapacityUsedString" xml:"CapacityUsedString"`
	Mode               string `json:"Mode" xml:"Mode"`
}

// CreateDescribeDcdnKvNamespaceRequest creates a request to invoke DescribeDcdnKvNamespace API
func CreateDescribeDcdnKvNamespaceRequest() (request *DescribeDcdnKvNamespaceRequest) {
	request = &DescribeDcdnKvNamespaceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnKvNamespace", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeDcdnKvNamespaceResponse creates a response to parse from DescribeDcdnKvNamespace response
func CreateDescribeDcdnKvNamespaceResponse() (response *DescribeDcdnKvNamespaceResponse) {
	response = &DescribeDcdnKvNamespaceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
