package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnWafBotAppKey invokes the dcdn.DescribeDcdnWafBotAppKey API synchronously
func (client *Client) DescribeDcdnWafBotAppKey(request *DescribeDcdnWafBotAppKeyRequest) (response *DescribeDcdnWafBotAppKeyResponse, err error) {
	response = CreateDescribeDcdnWafBotAppKeyResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnWafBotAppKeyWithChan invokes the dcdn.DescribeDcdnWafBotAppKey API asynchronously
func (client *Client) DescribeDcdnWafBotAppKeyWithChan(request *DescribeDcdnWafBotAppKeyRequest) (<-chan *DescribeDcdnWafBotAppKeyResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnWafBotAppKeyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnWafBotAppKey(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnWafBotAppKeyWithCallback invokes the dcdn.DescribeDcdnWafBotAppKey API asynchronously
func (client *Client) DescribeDcdnWafBotAppKeyWithCallback(request *DescribeDcdnWafBotAppKeyRequest, callback func(response *DescribeDcdnWafBotAppKeyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnWafBotAppKeyResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnWafBotAppKey(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnWafBotAppKeyRequest is the request struct for api DescribeDcdnWafBotAppKey
type DescribeDcdnWafBotAppKeyRequest struct {
	*requests.RpcRequest
}

// DescribeDcdnWafBotAppKeyResponse is the response struct for api DescribeDcdnWafBotAppKey
type DescribeDcdnWafBotAppKeyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	AppKey    string `json:"AppKey" xml:"AppKey"`
}

// CreateDescribeDcdnWafBotAppKeyRequest creates a request to invoke DescribeDcdnWafBotAppKey API
func CreateDescribeDcdnWafBotAppKeyRequest() (request *DescribeDcdnWafBotAppKeyRequest) {
	request = &DescribeDcdnWafBotAppKeyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnWafBotAppKey", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnWafBotAppKeyResponse creates a response to parse from DescribeDcdnWafBotAppKey response
func CreateDescribeDcdnWafBotAppKeyResponse() (response *DescribeDcdnWafBotAppKeyResponse) {
	response = &DescribeDcdnWafBotAppKeyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
