package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRoutineRelatedDomains invokes the dcdn.DescribeRoutineRelatedDomains API synchronously
func (client *Client) DescribeRoutineRelatedDomains(request *DescribeRoutineRelatedDomainsRequest) (response *DescribeRoutineRelatedDomainsResponse, err error) {
	response = CreateDescribeRoutineRelatedDomainsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRoutineRelatedDomainsWithChan invokes the dcdn.DescribeRoutineRelatedDomains API asynchronously
func (client *Client) DescribeRoutineRelatedDomainsWithChan(request *DescribeRoutineRelatedDomainsRequest) (<-chan *DescribeRoutineRelatedDomainsResponse, <-chan error) {
	responseChan := make(chan *DescribeRoutineRelatedDomainsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRoutineRelatedDomains(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRoutineRelatedDomainsWithCallback invokes the dcdn.DescribeRoutineRelatedDomains API asynchronously
func (client *Client) DescribeRoutineRelatedDomainsWithCallback(request *DescribeRoutineRelatedDomainsRequest, callback func(response *DescribeRoutineRelatedDomainsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRoutineRelatedDomainsResponse
		var err error
		defer close(result)
		response, err = client.DescribeRoutineRelatedDomains(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRoutineRelatedDomainsRequest is the request struct for api DescribeRoutineRelatedDomains
type DescribeRoutineRelatedDomainsRequest struct {
	*requests.RpcRequest
	Name string `position:"Body" name:"Name"`
}

// DescribeRoutineRelatedDomainsResponse is the response struct for api DescribeRoutineRelatedDomains
type DescribeRoutineRelatedDomainsResponse struct {
	*responses.BaseResponse
	Content   map[string]interface{} `json:"Content" xml:"Content"`
	RequestId string                 `json:"RequestId" xml:"RequestId"`
}

// CreateDescribeRoutineRelatedDomainsRequest creates a request to invoke DescribeRoutineRelatedDomains API
func CreateDescribeRoutineRelatedDomainsRequest() (request *DescribeRoutineRelatedDomainsRequest) {
	request = &DescribeRoutineRelatedDomainsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeRoutineRelatedDomains", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeRoutineRelatedDomainsResponse creates a response to parse from DescribeRoutineRelatedDomains response
func CreateDescribeRoutineRelatedDomainsResponse() (response *DescribeRoutineRelatedDomainsResponse) {
	response = &DescribeRoutineRelatedDomainsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
