package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDcdnKv invokes the dcdn.GetDcdnKv API synchronously
func (client *Client) GetDcdnKv(request *GetDcdnKvRequest) (response *GetDcdnKvResponse, err error) {
	response = CreateGetDcdnKvResponse()
	err = client.DoAction(request, response)
	return
}

// GetDcdnKvWithChan invokes the dcdn.GetDcdnKv API asynchronously
func (client *Client) GetDcdnKvWithChan(request *GetDcdnKvRequest) (<-chan *GetDcdnKvResponse, <-chan error) {
	responseChan := make(chan *GetDcdnKvResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDcdnKv(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDcdnKvWithCallback invokes the dcdn.GetDcdnKv API asynchronously
func (client *Client) GetDcdnKvWithCallback(request *GetDcdnKvRequest, callback func(response *GetDcdnKvResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDcdnKvResponse
		var err error
		defer close(result)
		response, err = client.GetDcdnKv(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDcdnKvRequest is the request struct for api GetDcdnKv
type GetDcdnKvRequest struct {
	*requests.RpcRequest
	Namespace string `position:"Query" name:"Namespace"`
	Key       string `position:"Query" name:"Key"`
}

// GetDcdnKvResponse is the response struct for api GetDcdnKv
type GetDcdnKvResponse struct {
	*responses.BaseResponse
	Value     string `json:"Value" xml:"Value"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateGetDcdnKvRequest creates a request to invoke GetDcdnKv API
func CreateGetDcdnKvRequest() (request *GetDcdnKvRequest) {
	request = &GetDcdnKvRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "GetDcdnKv", "", "")
	request.Method = requests.GET
	return
}

// CreateGetDcdnKvResponse creates a response to parse from GetDcdnKv response
func CreateGetDcdnKvResponse() (response *GetDcdnKvResponse) {
	response = &GetDcdnKvResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
