package dfs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AttachVscMountPoint invokes the dfs.AttachVscMountPoint API synchronously
func (client *Client) AttachVscMountPoint(request *AttachVscMountPointRequest) (response *AttachVscMountPointResponse, err error) {
	response = CreateAttachVscMountPointResponse()
	err = client.DoAction(request, response)
	return
}

// AttachVscMountPointWithChan invokes the dfs.AttachVscMountPoint API asynchronously
func (client *Client) AttachVscMountPointWithChan(request *AttachVscMountPointRequest) (<-chan *AttachVscMountPointResponse, <-chan error) {
	responseChan := make(chan *AttachVscMountPointResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AttachVscMountPoint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AttachVscMountPointWithCallback invokes the dfs.AttachVscMountPoint API asynchronously
func (client *Client) AttachVscMountPointWithCallback(request *AttachVscMountPointRequest, callback func(response *AttachVscMountPointResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AttachVscMountPointResponse
		var err error
		defer close(result)
		response, err = client.AttachVscMountPoint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AttachVscMountPointRequest is the request struct for api AttachVscMountPoint
type AttachVscMountPointRequest struct {
	*requests.RpcRequest
	VscType       string    `position:"Query" name:"VscType"`
	Description   string    `position:"Query" name:"Description"`
	InputRegionId string    `position:"Query" name:"InputRegionId"`
	MountPointId  string    `position:"Query" name:"MountPointId"`
	FileSystemId  string    `position:"Query" name:"FileSystemId"`
	VscIds        *[]string `position:"Query" name:"VscIds"  type:"Json"`
	InstanceIds   string    `position:"Query" name:"InstanceIds"`
}

// AttachVscMountPointResponse is the response struct for api AttachVscMountPoint
type AttachVscMountPointResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAttachVscMountPointRequest creates a request to invoke AttachVscMountPoint API
func CreateAttachVscMountPointRequest() (request *AttachVscMountPointRequest) {
	request = &AttachVscMountPointRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DFS", "2018-06-20", "AttachVscMountPoint", "alidfs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAttachVscMountPointResponse creates a response to parse from AttachVscMountPoint response
func CreateAttachVscMountPointResponse() (response *AttachVscMountPointResponse) {
	response = &AttachVscMountPointResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
