package dfs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAccessGroups invokes the dfs.ListAccessGroups API synchronously
func (client *Client) ListAccessGroups(request *ListAccessGroupsRequest) (response *ListAccessGroupsResponse, err error) {
	response = CreateListAccessGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// ListAccessGroupsWithChan invokes the dfs.ListAccessGroups API asynchronously
func (client *Client) ListAccessGroupsWithChan(request *ListAccessGroupsRequest) (<-chan *ListAccessGroupsResponse, <-chan error) {
	responseChan := make(chan *ListAccessGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAccessGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAccessGroupsWithCallback invokes the dfs.ListAccessGroups API asynchronously
func (client *Client) ListAccessGroupsWithCallback(request *ListAccessGroupsRequest, callback func(response *ListAccessGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAccessGroupsResponse
		var err error
		defer close(result)
		response, err = client.ListAccessGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAccessGroupsRequest is the request struct for api ListAccessGroups
type ListAccessGroupsRequest struct {
	*requests.RpcRequest
	InputRegionId string           `position:"Query" name:"InputRegionId"`
	Limit         requests.Integer `position:"Query" name:"Limit"`
	OrderBy       string           `position:"Query" name:"OrderBy"`
	StartOffset   requests.Integer `position:"Query" name:"StartOffset"`
	OrderType     string           `position:"Query" name:"OrderType"`
}

// ListAccessGroupsResponse is the response struct for api ListAccessGroups
type ListAccessGroupsResponse struct {
	*responses.BaseResponse
	TotalCount   int           `json:"TotalCount" xml:"TotalCount"`
	RequestId    string        `json:"RequestId" xml:"RequestId"`
	AccessGroups []AccessGroup `json:"AccessGroups" xml:"AccessGroups"`
}

// CreateListAccessGroupsRequest creates a request to invoke ListAccessGroups API
func CreateListAccessGroupsRequest() (request *ListAccessGroupsRequest) {
	request = &ListAccessGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DFS", "2018-06-20", "ListAccessGroups", "alidfs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListAccessGroupsResponse creates a response to parse from ListAccessGroups response
func CreateListAccessGroupsResponse() (response *ListAccessGroupsResponse) {
	response = &ListAccessGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
