package dms_dg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckDGEnabled invokes the dms_dg.CheckDGEnabled API synchronously
func (client *Client) CheckDGEnabled(request *CheckDGEnabledRequest) (response *CheckDGEnabledResponse, err error) {
	response = CreateCheckDGEnabledResponse()
	err = client.DoAction(request, response)
	return
}

// CheckDGEnabledWithChan invokes the dms_dg.CheckDGEnabled API asynchronously
func (client *Client) CheckDGEnabledWithChan(request *CheckDGEnabledRequest) (<-chan *CheckDGEnabledResponse, <-chan error) {
	responseChan := make(chan *CheckDGEnabledResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckDGEnabled(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckDGEnabledWithCallback invokes the dms_dg.CheckDGEnabled API asynchronously
func (client *Client) CheckDGEnabledWithCallback(request *CheckDGEnabledRequest, callback func(response *CheckDGEnabledResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckDGEnabledResponse
		var err error
		defer close(result)
		response, err = client.CheckDGEnabled(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckDGEnabledRequest is the request struct for api CheckDGEnabled
type CheckDGEnabledRequest struct {
	*requests.RpcRequest
}

// CheckDGEnabledResponse is the response struct for api CheckDGEnabled
type CheckDGEnabledResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Data      string `json:"Data" xml:"Data"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateCheckDGEnabledRequest creates a request to invoke CheckDGEnabled API
func CreateCheckDGEnabledRequest() (request *CheckDGEnabledRequest) {
	request = &CheckDGEnabledRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-dg", "2023-09-14", "CheckDGEnabled", "", "")
	request.Method = requests.POST
	return
}

// CreateCheckDGEnabledResponse creates a response to parse from CheckDGEnabled response
func CreateCheckDGEnabledResponse() (response *CheckDGEnabledResponse) {
	response = &CheckDGEnabledResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
